<?php
/**
 * SOL · API · Reporte de Errores de Picking
 */
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');

$BASE = dirname(__DIR__, 2);
require_once $BASE . '/config/config.php';
require_once $BASE . '/config/db.php';
require_once $BASE . '/app/Support/Reportes/ErroresPickingReport.php';

if (empty($_SESSION['usuario_id'])) {
    http_response_code(401);
    echo json_encode(['ok' => false, 'error' => 'No autorizado'], JSON_UNESCAPED_UNICODE);
    exit;
}

try {
    $pdo = getPDO();
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    if (!empty($_GET['meta'])) {
        $meta = strtolower(trim((string) $_GET['meta']));
        if (in_array($meta, ['filters', 'combos'], true)) {
            $combos = errores_picking_fetch_combos($pdo);
            echo json_encode(['ok' => true] + $combos, JSON_UNESCAPED_UNICODE);
            exit;
        }
    }

    $limit = isset($_GET['limit']) ? (int) $_GET['limit'] : 1000;
    $data = errores_picking_fetch_data($pdo, $_GET, $limit);

    echo json_encode(['ok' => true] + $data, JSON_UNESCAPED_UNICODE);
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode([
        'ok' => false,
        'error' => 'Error al generar el reporte de errores de picking',
        'message' => env('APP_ENV') === 'local' ? $e->getMessage() : '',
    ], JSON_UNESCAPED_UNICODE);
}
