<?php
/**
 * SOL · API · Reporte de Facturación y Rendiciones
 */
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');

$BASE = dirname(__DIR__, 2);
require_once $BASE . '/config/config.php';
require_once $BASE . '/config/db.php';
require_once $BASE . '/app/Support/Reportes/FacturacionReport.php';

if (empty($_SESSION['usuario_id'])) {
    try {
        $logPath = BASE_PATH . '/tmp/facturacion_error.log';
        $payload = '[' . date('c') . "] API facturacion unauthorized. Session keys: " . implode(',', array_keys($_SESSION ?? []));
        file_put_contents($logPath, $payload . PHP_EOL, FILE_APPEND);
    } catch (Throwable $logEx) {
        error_log('Facturacion API unauthorized log failure: ' . $logEx->getMessage());
    }
    http_response_code(401);
    echo json_encode(['ok' => false, 'error' => 'No autorizado'], JSON_UNESCAPED_UNICODE);
    exit;
}

try {
    $pdo = getPDO();
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    if (!empty($_GET['meta'])) {
        $meta = strtolower((string) $_GET['meta']);
        if (in_array($meta, ['filters', 'combos'], true)) {
            $combos = facturacion_fetch_combos($pdo);
            echo json_encode(['ok' => true] + $combos, JSON_UNESCAPED_UNICODE);
            exit;
        }
    }

    $limit = isset($_GET['limit']) ? (int) $_GET['limit'] : 1000;
    $data = facturacion_fetch_data($pdo, $_GET, $limit);

    echo json_encode(['ok' => true] + $data, JSON_UNESCAPED_UNICODE);
} catch (Throwable $e) {
    try {
        $logPath = BASE_PATH . '/tmp/facturacion_error.log';
        $message = '[' . date('c') . "] API facturacion filters/data error: " . $e->getMessage();
        if (function_exists('file_put_contents')) {
            file_put_contents($logPath, $message . PHP_EOL, FILE_APPEND);
        }
    } catch (Throwable $logEx) {
        error_log('Facturacion API log failure: ' . $logEx->getMessage());
    }
    http_response_code(500);
    echo json_encode([
        'ok' => false,
        'error' => 'Error al generar el reporte de facturación',
        'message' => env('APP_ENV') === 'local' ? $e->getMessage() : '',
    ], JSON_UNESCAPED_UNICODE);
}
