<?php

declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');

$BASE = dirname(__DIR__, 2);
require_once $BASE . '/config/config.php';
require_once $BASE . '/config/db.php';
require_once $BASE . '/app/Support/Reportes/ServicioClienteReport.php';

if (empty($_SESSION['usuario_id'])) {
    http_response_code(401);
    echo json_encode(['ok' => false, 'error' => 'No autorizado'], JSON_UNESCAPED_UNICODE);
    exit;
}

try {
    $pdo = function_exists('getPDO') ? getPDO() : get_pdo();
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    if (isset($_GET['meta'])) {
        $meta = strtolower(trim((string) $_GET['meta']));
        if (in_array($meta, ['filters', 'combos', 'catalogos'], true)) {
            echo json_encode(['ok' => true] + servicio_cliente_fetch_filters($pdo), JSON_UNESCAPED_UNICODE);
            return;
        }
    }

    $data = servicio_cliente_fetch_data($pdo, $_GET);
    echo json_encode(['ok' => true] + $data, JSON_UNESCAPED_UNICODE);
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode([
        'ok'    => false,
        'error' => 'Error al generar el reporte de servicio al cliente',
        'msg'   => env('APP_ENV') === 'local' ? $e->getMessage() : '',
    ], JSON_UNESCAPED_UNICODE);
}
