<?php
/**
 * SOL · API · Reporte de Trazabilidad de Productos
 */
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');

$BASE = dirname(__DIR__, 2);
require_once $BASE . '/config/config.php';
require_once $BASE . '/config/db.php';
require_once $BASE . '/app/Support/Reportes/TrazabilidadProductosReport.php';

if (empty($_SESSION['usuario_id'])) {
    http_response_code(401);
    echo json_encode(['ok' => false, 'error' => 'No autorizado'], JSON_UNESCAPED_UNICODE);
    exit;
}

try {
    $pdo = getPDO();
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    if (!empty($_GET['meta'])) {
        $meta = strtolower(trim((string) $_GET['meta']));
        if ($meta === 'productos') {
            $q = (string) ($_GET['term'] ?? ($_GET['q'] ?? ''));
            $productos = traza_search_productos($pdo, $q);
            echo json_encode(['ok' => true, 'productos' => $productos], JSON_UNESCAPED_UNICODE);
            exit;
        }
    }

    $data = traza_fetch_data($pdo, $_GET);
    echo json_encode(['ok' => true] + $data, JSON_UNESCAPED_UNICODE);
} catch (RuntimeException $e) {
    http_response_code(422);
    echo json_encode([
        'ok' => false,
        'error' => $e->getMessage(),
    ], JSON_UNESCAPED_UNICODE);
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode([
        'ok' => false,
        'error' => 'Error al generar el reporte de trazabilidad',
        'message' => env('APP_ENV') === 'local' ? $e->getMessage() : '',
    ], JSON_UNESCAPED_UNICODE);
}
