<?php
declare(strict_types=1);

/**
 * API: Listado de usuarios del sistema (sys_users)
 * Método: GET
 * Parámetros opcionales:
 *  - q: filtro por texto en username o full_name
 *  - limit: máximo de filas (por defecto 200)
 */

header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');

$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

function out(array $p, int $c=200){ http_response_code($c); echo json_encode($p, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }

try {
  $q = isset($_GET['q']) ? trim((string)$_GET['q']) : '';
  $limit = isset($_GET['limit']) ? max(1, min(1000, (int)$_GET['limit'])) : 200;

  $pdo = get_pdo();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
  $pdo->exec('SET NAMES utf8mb4');

  $sql = "SELECT id, username, COALESCE(full_name, username) AS full_name FROM sys_users";
  $params = [];
  if ($q !== '') {
    $sql .= " WHERE username LIKE ? OR full_name LIKE ?";
    $params[] = "%{$q}%";
    $params[] = "%{$q}%";
  }
  $sql .= " ORDER BY COALESCE(full_name, username) ASC LIMIT {$limit}";
  $st = $pdo->prepare($sql);
  $st->execute($params);
  $rows = $st->fetchAll(PDO::FETCH_ASSOC) ?: [];

  // Normalizar shape {id, username, full_name, name}
  $data = array_map(function($r){
    $name = $r['full_name'] ?: $r['username'];
    return [
      'id' => (int)$r['id'],
      'username' => (string)$r['username'],
      'full_name' => (string)$r['full_name'],
      'name' => $name,
    ];
  }, $rows);

  out(['ok'=>true, 'data'=>$data, 'count'=>count($data)]);
} catch (Throwable $e) {
  out(['ok'=>false,'error'=>'No se pudieron listar usuarios','message'=>$e->getMessage()], 500);
}

?>
