<?php
// app/Support/Auth.php
declare(strict_types=1);

function current_user_id(): ?int {
    if (session_status() === PHP_SESSION_NONE) session_start();

    // Busca en las variantes más comunes que usaste en el proyecto
    if (isset($_SESSION['usuario_id'])) {
        return (int) $_SESSION['usuario_id'];
    }
    if (isset($_SESSION['user']['id'])) {
        return (int) $_SESSION['user']['id'];
    }
    if (isset($_SESSION['user_id'])) {
        return (int) $_SESSION['user_id'];
    }
    return null;
}

/**
 * is_admin - simple role check used by admin-only tools
 *
 * Heuristics used (in order):
 * - $_SESSION['is_admin'] truthy flag
 * - $_SESSION['usuario_rol'] or other common role keys matching /admin|administrador/i
 * - fallback: false
 */
function is_admin(): bool {
    if (session_status() === PHP_SESSION_NONE) session_start();
    if (!empty($_SESSION['is_admin'])) return true;
    $roleCandidates = [
        $_SESSION['usuario_rol'] ?? null,
        $_SESSION['user']['role'] ?? null,
        $_SESSION['role'] ?? null,
    ];
    foreach ($roleCandidates as $r) {
        if (!$r) continue;
        if (preg_match('/admin|administrador|superuser|sysadmin/i', (string)$r)) return true;
    }
    return false;
}
