<?php
namespace App;

class LayoutBuilder
{
    /**
     * Generate position codes for the given ranges.
     * Returns an array of entries with keys: code, code_full, rack, columna, nivel, fondo
     * If $limit is provided, generation will stop after $limit entries (useful for preview).
     *
     * @param string $depCode
     * @param int $racks
     * @param int $cols
     * @param int $niveles
     * @param int $fondos
     * @param int|null $limit
     * @return array
     */
    public static function generatePositions(string $depCode, int $racks, int $cols, int $niveles, int $fondos, ?int $limit = null): array
    {
        $out = [];
        $count = 0;
        for ($ri = 1; $ri <= $racks; $ri++) {
            for ($ci = 1; $ci <= $cols; $ci++) {
                for ($ni = 1; $ni <= $niveles; $ni++) {
                    for ($fi = 1; $fi <= $fondos; $fi++) {
                        $rackCode = sprintf('R%02d', $ri);
                        $colCode = sprintf('C%02d', $ci);
                        $nivCode = sprintf('N%02d', $ni);
                        $fCode = sprintf('F%02d', $fi);
                        $code = "$rackCode-$colCode-$nivCode-$fCode";
                        $code_full = trim($depCode . '-' . $code, '-');
                        $out[] = [
                            'code' => $code,
                            'code_full' => $code_full,
                            'rack' => $ri,
                            'columna' => $ci,
                            'nivel' => $ni,
                            'fondo' => $fi,
                        ];
                        $count++;
                        if ($limit !== null && $count >= $limit) {
                            return $out;
                        }
                    }
                }
            }
        }
        return $out;
    }
}
