<?php
/**
 * SOL - Backend de Login (ajustado a sys_users: username / pass_hash)
 */

declare(strict_types=1);

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/db.php';

function back_to_login(string $msg): void {
    $login = url('/login');
    $sep   = (str_contains($login, '?') ? '&' : '?');
    if (!headers_sent()) {
        header('Location: ' . $login . $sep . 'e=' . urlencode($msg));
    } else {
        echo '<script>location.href=' . json_encode($login . $sep . 'e=' . rawurlencode($msg)) . ';</script>';
    }
    exit;
}

if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'POST') {
    back_to_login('Método inválido');
}

$inputUser = trim((string)($_POST['usuario']  ?? ''));
$inputPass = (string)($_POST['password'] ?? '');

if ($inputUser === '' || $inputPass === '') {
    back_to_login('Ingrese usuario y contraseña');
}

try {
    $pdo = getPDO();

    // sys_users: id, username, full_name, email, pass_hash, role_code, operativa_id ...
    // (según el dump)  :contentReference[oaicite:2]{index=2}
    $sql = "SELECT sys_users.id, username, full_name, email, pass_hash, sys_role.name role_name, role_code, operativa_id, foto
            FROM sys_users
            LEFT JOIN sys_role ON sys_role.id = sys_users.role_code
            WHERE username = :u
            LIMIT 1";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([':u' => $inputUser]);
    $row = $stmt->fetch();

    if (!$row) {
        back_to_login('Usuario o clave inválidos');
    }

    $hash = (string)($row['pass_hash'] ?? '');
    $ok = false;

    if ($hash !== '' && $hash[0] === '$') {
        // Hash (bcrypt/argon)
        $ok = password_verify($inputPass, $hash);
    } else {
        // Texto plano (solo legacy)
        $ok = hash_equals($hash, $inputPass);
    }

    if (!$ok) {
        back_to_login('Usuario o clave inválidos');
    }

    // Set sesión con nombres consistentes con config.php
    $_SESSION['usuario_id']      = (int)$row['id'];
    $_SESSION['usuario_login']   = (string)$row['username'];
    $_SESSION['usuario_nombre']  = (string)($row['full_name'] ?? $row['username']);
    $_SESSION['usuario_rol']     = (string)($row['role_name'] ?? 'user'); // num o string
    $_SESSION['rolecode']        = (string)($row['role_code'] ?? 'user'); // compat
    $_SESSION['operativa']       = $row['operativa_id'] ?? null;
    $_SESSION['foto']            = $row['foto'] ?? null;
    $_SESSION['__last_activity'] = time();

    $dashboardUrl = url('/home');
    if (!headers_sent()) {
        header('Location: ' . $dashboardUrl);
    } else {
        echo '<script>location.href=' . json_encode($dashboardUrl) . ';</script>';
    }
    exit;

} catch (Throwable $e) {
    if ((bool)env('APP_DEBUG', false)) {
        error_log('[auth_login] ' . $e->getMessage());
        back_to_login('Error: ' . $e->getMessage());
    }
    back_to_login('Error interno. Intente de nuevo.');
}
