<?php

declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Config: Menú principal (fuente única de verdad)
 *
 * - Estructura jerárquica compatible con futuros roles/permisos.
 * - Claves estándar por ítem:
 *     id        : string único
 *     label     : texto visible
 *     icon      : nombre de icono (feather icon)
 *     url       : path absoluto dentro de la app (o null para dropdown)
 *     section   : bool (si es separador/título de sección)
 *     visible   : bool
 *     roles     : array<string> (opcional, para control por rol a futuro)
 *     children  : array de subitems (mismo esquema)
 *
 * - Nota: Este archivo NO hace validación de rutas.
 *         Más adelante haremos que public/index.php cargue config/routes.php
 *         y valide que cada url del menú exista como ruta.
 */

return [
    // =========================
    // Sección: General
    // =========================
    [
        'id'      => 'sec-general',
        'label'   => 'General',
        'section' => true,
        'visible' => true,
        'roles'   => [],   // visible para todos
    ],
    [
        'id'       => 'home',
        'label'    => 'Inicio',
        'icon'     => 'home',
        'url'      => '/home',
        'visible'  => true,
        'roles'    => [],
        'children' => [],
    ],
    [
        'id'       => 'dashboard',
        'label'    => 'Dashboard',
        'icon'     => 'grid',
        'url'      => '/control/dashboard',
        'visible'  => true,
        'roles'    => [],
        'children' => [],
    ],


    // =========================
    // Sección: Operaciones
    // =========================
    [
        'id'      => 'sec-operaciones',
        'label'   => 'Operaciones',
        'section' => true,
        'visible' => true,
        'roles'   => [],
    ],
    [
        'id'       => 'ingresos',
        'label'    => 'Ingresos',
        'icon'     => 'list',
        'url'      => null, // dropdown
        'visible'  => true,
        'roles'    => [],
        'children' => [
            [
                'id'       => 'ingresos-packing',
                'label'    => 'Packing List de Ingreso',
                'icon'     => 'users',
                'url'      => '/ingresos/packing',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'ingresos-recepcion',
                'label'    => 'Recepción',
                'icon'     => 'users',
                'url'      => '/ingresos/recepcion',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'ingresos-listado',
                'label'    => 'Ingresos',
                'icon'     => 'users',
                'url'      => '/ingresos/listado',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            // 👇 Ruta oculta para detalle
            [
                'id'       => 'ingresos-detalle',
                'label'    => 'Detalle de ingreso',
                'icon'     => 'file-text',
                'url'      => '/ingresos/detalle',
                'visible'  => false, // oculta en el sidebar
                'roles'    => [],
                'children' => [],
            ],
            // 👇 Ruta oculta para asignar posiciones
            [
                'id'       => 'ingresos-asignar-posiciones',
                'label'    => 'Asignar Posiciones',
                'icon'     => 'grid',
                'url'      => '/ingresos/asignar_posiciones',
                'visible'  => false, // oculta en el sidebar
                'roles'    => [],
                'children' => [],
            ],
        ],
    ],
    [
        'id'       => 'deposito',
        'label'    => 'Depósito',
        'icon'     => 'list',
        'url'      => null, // dropdown
        'visible'  => true,
        'roles'    => [],
        'children' => [
            [
                'id'       => 'deposito-rotacion',
                'label'    => 'Rotación',
                'icon'     => 'users',
                'url'      => '/deposito/rotacion',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'deposito-cuarentena',
                'label'    => 'Pallets en Cuarentena',
                'icon'     => 'alert-triangle',
                'url'      => '/deposito/cuarentena',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'deposito-inmovilizados',
                'label'    => 'Productos inmovilizados',
                'icon'     => 'users',
                'url'      => '/deposito/inmovilizados',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'deposito-layout',
                'label'    => 'Layout del depósito',
                'icon'     => 'grid',
                'url'      => '/deposito/layout',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
        ],
    ],    
    [
        'id'       => 'salidas',
        'label'    => 'Salidas',
        'icon'     => 'list',
        'url'      => null, // dropdown
        'visible'  => true,
        'roles'    => [],
        'children' => [
            [
                'id'       => 'salidas-packing',
                'label'    => 'Packing List de Pedidos',
                'icon'     => 'upload',
                'url'      => '/salidas/packing',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'salidas-listado',
                'label'    => 'Pedidos',
                'icon'     => 'users',
                'url'      => '/salidas/listado',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            // Oculto: módulo de preparación (se navega desde listado)
            [
                'id'       => 'salidas-preparacion',
                'label'    => 'Preparación',
                'icon'     => 'check-square',
                'url'      => '/salidas/preparacion',
                'visible'  => false,
                'roles'    => [],
                'children' => [],
            ],
            // Módulo de Embarque
            [
                'id'       => 'salidas-embarque',
                'label'    => 'Embarque',
                'icon'     => 'truck',
                'url'      => '/salidas/embarque',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'salidas-planilla',
                'label'    => 'Planilla de Embarque',
                'icon'     => 'truck',
                'url'      => '/salidas/embarque/planilla',
                'visible'  => false,
                'roles'    => [],
                'children' => [],
            ],
            // Ruta oculta de detalle de Embarque
            [
                'id'       => 'salidas-embarque-detalle',
                'label'    => 'Detalle de embarque',
                'icon'     => 'file-text',
                'url'      => '/salidas/embarque/detalle',
                'visible'  => false,
                'roles'    => [],
                'children' => [],
            ],
            // 👇 Ruta oculta para detalle
            [
                'id'       => 'salidas-detalle',
                'label'    => 'Detalle de salida',
                'icon'     => 'file-text',
                'url'      => '/salidas/detalle',
                'visible'  => false, // oculta en el sidebar
                'roles'    => [],
                'children' => [],
            ],
        ],
    ],
    [
        'id'       => 'operaciones-moviles',
        'label'    => 'Operaciones',
        'icon'     => 'list',
        'url'      => null, // dropdown
        'visible'  => true,
        'roles'    => [],
        'children' => [
            [
                'id'       => 'operaciones-moviles-disponibles',
                'label'    => 'Móviles disponibles',
                'icon'     => 'calendar',
                'url'      => '/operaciones/moviles_disponibles',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
        ],
    ], 
    [
        'id'       => 'control',
        'label'    => 'Control',
        'icon'     => 'list',
        'url'      => null, // dropdown
        'visible'  => true,
        'roles'    => [],
        'children' => [
            [
                'id'       => 'control-panel',
                'label'    => 'Panel de Control',
                'icon'     => 'grid',
                'url'      => '/control',
                'visible'  => false,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'ingresos-mapeo',
                'label'    => 'Mapeo',
                'icon'     => 'users',
                'url'      => '/control/mapeo',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'ingresos-conteo',
                'label'    => 'Conteo por Layout',
                'icon'     => 'map',
                'url'      => '/control/conteo',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'control-inventario',
                'label'    => 'Inventario / Conteos',
                'icon'     => 'clipboard',
                'url'      => '/control/inventario',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            // 👇 Ruta oculta para nuevo conteo
            [
                'id'       => 'control-inventario-nuevo',
                'label'    => 'Nuevo Conteo',
                'icon'     => 'plus',
                'url'      => '/control/inventario/nuevo',
                'visible'  => false, // oculta en el sidebar
                'roles'    => [],
                'children' => [],
            ],
            // 👇 Ruta oculta para editar conteo
            [
                'id'       => 'control-inventario-editar',
                'label'    => 'Editar Conteo',
                'icon'     => 'edit',
                'url'      => '/control/inventario/editar',
                'visible'  => false, // oculta en el sidebar
                'roles'    => [],
                'children' => [],
            ],
        ],
    ],

    // =========================
    // Sección: Parámetros
    // =========================
    [
        'id'      => 'sec-configuraciones',
        'label'   => 'Configuraciones',
        'section' => true,
        'visible' => true,
        'roles'   => [],
    ],
    [
        'id'       => 'parametros',
        'label'    => 'Parámetros',
        'icon'     => 'settings',
        'url'      => null,      // null = dropdown (no clic directo)
        'visible'  => true,
        'roles'    => [],
        'children' => [
            [
                'id'       => 'parametros-panel',
                'label'    => 'Panel de Parámetros',
                'icon'     => 'grid',
                'url'      => '/parametros',
                'visible'  => false,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'param-clientes',
                'label'    => 'Clientes',
                'icon'     => 'users',
                'url'      => '/parametros/clientes',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'param-choferes',
                'label'    => 'Choferes',
                'icon'     => 'users',
                'url'      => '/parametros/choferes',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'param-clases',
                'label'    => 'Clases',
                'icon'     => 'grid',
                'url'      => '/parametros/clases',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'param-destinatarios',
                'label'    => 'Destinatarios',
                'icon'     => 'grid',
                'url'      => '/parametros/destinatarios',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'param-grupos',
                'label'    => 'Grupos',
                'icon'     => 'plus-square',
                'url'      => '/parametros/grupos',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'param-productos',
                'label'    => 'Productos',
                'icon'     => 'box',
                'url'      => '/parametros/productos',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'param-moviles',
                'label'    => 'Móviles',
                'icon'     => 'box',
                'url'      => '/parametros/moviles',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'param-transportadoras',
                'label'    => 'Transportadoras',
                'icon'     => 'box',
                'url'      => '/parametros/transportadoras',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
        ],
    ],

    // =========================
    // Sección: Inventario
    // =========================
    [
        'id'      => 'sec-inventario',
        'label'   => 'Inventario',
        'section' => true,
        'visible' => true,
        'roles'   => [],
    ],
    [
        'id'       => 'inventario',
        'label'    => 'Informes de Inventario',
        'icon'     => 'bar-chart-2',
        'url'      => null,      // null = dropdown (no clic directo)
        'visible'  => true,
        'roles'    => [],
        'children' => [
            [
                'id'       => 'inventario-existencias',
                'label'    => 'Existencias actuales',
                'icon'     => 'users',
                'url'      => '/inventario/existencias',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'inventario-movimientos',
                'label'    => 'Movimientos de inventario',
                'icon'     => 'shuffle',
                'url'      => '/inventario/movimientos',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'inventario-min_max',
                'label'    => 'Existencias mínimas y máximas',
                'icon'     => 'users',
                'url'      => '/inventario/min_max',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'inventario-a_caducar',
                'label'    => 'Próximos a caducar',
                'icon'     => 'users',
                'url'      => '/inventario/a_caducar',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'inventario-fisico-vs-registrado',
                'label'    => 'Físico vs. Registrado',
                'icon'     => 'users',
                'url'      => '/inventario/fisico_vs_registrado',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'inventario-ubicacion',
                'label'    => 'Por ubicación',
                'icon'     => 'users',
                'url'      => '/inventario/ubicacion',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
        ],
    ],
    // =========================
    // Sección: Productos
    // =========================
    [
        'id'      => 'sec-Productos',
        'label'   => 'Productos',
        'section' => true,
        'visible' => true,
        'roles'   => [],
    ],
    [
        'id'       => 'perecederos',
        'label'    => 'Perecederos',
        'icon'     => 'bar-chart-2',
        'url'      => null,      // null = dropdown (no clic directo)
        'visible'  => true,
        'roles'    => [],
        'children' => [
            [
                'id'       => 'perecederos-por_vencer',
                'label'    => 'Existencias por vencer',
                'icon'     => 'users',
                'url'      => '/perecederos/por_vencer',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'perecederos-merma_por_caducidad',
                'label'    => 'Merma por caducidad',
                'icon'     => 'users',
                'url'      => '/perecederos/merma_por_caducidad',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
        ],
    ],
    [
        'id'       => 'rotacion',
        'label'    => 'Rotación',
        'icon'     => 'bar-chart-2',
        'url'      => null,      // null = dropdown (no clic directo)
        'visible'  => true,
        'roles'    => [],
        'children' => [
            [
                'id'       => 'rotacion-minmax',
                'label'    => 'Mayor y menor rotación',
                'icon'     => 'users',
                'url'      => '/rotacion/minmax',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'rotacion-permanencia',
                'label'    => 'Permanencia en almacén',
                'icon'     => 'users',
                'url'      => '/rotacion/permanencia',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
        ],
    ],
    // =========================
    // Sección: Movimientos
    // =========================
    [
        'id'      => 'sec-movimientos',
        'label'   => 'Movimientos',
        'section' => true,
        'visible' => true,
        'roles'   => [],
    ],
    [
        'id'       => 'recepcion',
        'label'    => 'Recepción',
        'icon'     => 'bar-chart-2',
        'url'      => null,      // null = dropdown (no clic directo)
        'visible'  => true,
        'roles'    => [],
        'children' => [
            [
                'id'       => 'recepcion-por_proveedor',
                'label'    => 'Recepción por proveedor',
                'icon'     => 'users',
                'url'      => '/recepcion/por_proveedor',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
        ],
    ],    
    // =========================
    // Sección: Reportes
    // =========================
    [
        'id'      => 'sec-reportes',
        'label'   => 'Reportes',
        'section' => true,
        'visible' => true,
        'roles'   => [],
    ],
    [
        'id'       => 'reportes',
        'label'    => 'Embarques',
        'icon'     => 'file-text',
        'url'      => '/reportes',      // null = dropdown (no clic directo)
        'visible'  => true,
        'roles'    => [],
        'children' => [
            [
                'id'       => 'reportes-pedidos',
                'label'    => 'Pedidos',
                'icon'     => 'file-text',
                'url'      => '/reportes/pedidos',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'reportes-ingresos',
                'label'    => 'Ingresos',
                'icon'     => 'download',
                'url'      => '/reportes/ingresos',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'reportes-salidas',
                'label'    => 'Salidas',
                'icon'     => 'truck',
                'url'      => '/reportes/salidas',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'reportes-moviles-disponibles',
                'label'    => 'Móviles disponibles',
                'icon'     => 'truck',
                'url'      => '/reportes/moviles_disponibles',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'reportes-embarques-monitoreo',
                'label'    => 'Monitoreo de Embarques',
                'icon'     => 'truck',
                'url'      => '/reportes/embarques_monitoreo',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'reportes-embarques-tiempos',
                'label'    => 'Análisis de Tiempos',
                'icon'     => 'clock',
                'url'      => '/reportes/embarques_tiempos',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'reportes-embarques-cumplimiento',
                'label'    => 'Cumplimiento de Entregas',
                'icon'     => 'check-circle',
                'url'      => '/reportes/embarques_cumplimiento',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'reportes-embarques-devoluciones',
                'label'    => 'Devoluciones y Retornos',
                'icon'     => 'rotate-ccw',
                'url'      => '/reportes/embarques_devoluciones',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
        ],
    ],
    [
        'id'       => 'reportes-bodega',
        'label'    => 'Bodega',
        'icon'     => 'archive',
        'url'      => null,
        'visible'  => true,
        'roles'    => [],
        'children' => [
            [
                'id'       => 'reportes-capacidades-bodega',
                'label'    => 'Capacidades de Bodega',
                'icon'     => 'rulers',
                'url'      => '/reportes/capacidades_bodega',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'reportes-almacenamiento',
                'label'    => 'Almacenamiento',
                'icon'     => 'archive',
                'url'      => '/reportes/almacenamiento',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'reportes-stock-quiebre',
                'label'    => 'Quiebre de Stock',
                'icon'     => 'alert-triangle',
                'url'      => '/reportes/stock_quiebre',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'reportes-trazabilidad-productos',
                'label'    => 'Trazabilidad de Productos',
                'icon'     => 'alert-triangle',
                'url'      => '/reportes/trazabilidad_productos',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'reportes-cobertura-sku',
                'label'    => 'Cobertura por SKU',
                'icon'     => 'target',
                'url'      => '/reportes/cobertura_sku',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
        ],
    ],
    [
        'id'       => 'reportes-distribucion',
        'label'    => 'Distribución',
        'icon'     => 'truck',
        'url'      => '/reportes/distribucion',
        'visible'  => true,
        'roles'    => [],
        'children' => [],
    ],
    [
        'id'       => 'reportes-servicio-cliente',
        'label'    => 'Servicio al Cliente',
        'icon'     => 'smile',
        'url'      => '/reportes/servicio_cliente',
        'visible'  => true,
        'roles'    => [],
        'children' => [],
    ],
    [
        'id'       => 'reportes-productividad',
        'label'    => 'Productividad',
        'icon'     => 'bi bi-person-check',
        'url'      => null,
        'visible'  => true,
        'roles'    => [],
        'children' => [
            [
                'id'       => 'reportes-pedidos-hora',
                'label'    => 'Pedidos por hora',
                'icon'     => 'clock',
                'url'      => '/reportes/pedidos_hora',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'reportes-errores-picking',
                'label'    => 'Errores de picking',
                'icon'     => 'alert-octagon',
                'url'      => '/reportes/errores_picking',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'reportes-clientes-otif',
                'label'    => 'Clientes · OTIF',
                'icon'     => 'users',
                'url'      => '/reportes/clientes_otif',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'reportes-facturacion',
                'label'    => 'Facturación y rendiciones',
                'icon'     => 'file-text',
                'url'      => '/reportes/facturacion',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'reportes-costo-entrega',
                'label'    => 'Costo por entregas (en desarrollo)',
                'icon'     => 'truck',
                'url'      => '/reportes/costo_entrega',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'reportes-costo-unidad',
                'label'    => 'Costo por unidad transportada (en desarrollo)',
                'icon'     => 'dollar-sign',
                'url'      => '/reportes/costo_unidad',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
            [
                'id'       => 'reportes-utilizacion-montacargas',
                'label'    => 'Utilización de montacargas (en desarrollo)',
                'icon'     => 'tool',
                'url'      => '/reportes/utilizacion_montacargas',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
        ],
    ],

    // =========================
    // Sección: Testing
    // =========================
    [
        'id'      => 'sec-testing',
        'label'   => 'Testing',
        'section' => true,
        'visible' => true,
        'roles'   => [],
    ],
    [
        'id'       => 'testing',
        'label'    => 'API',
        'icon'     => 'terminal',
        'url'      => null,      // null = dropdown (no clic directo)
        'visible'  => true,
        'roles'    => [],
        'children' => [
            [
                'id'       => 'testing-wh-in',
                'label'    => 'Ingreso (IN a CUARENTENA)',
                'icon'     => 'inbox',
                'url'      => '/testing/wh_in',
                'visible'  => true,
                'roles'    => [],
                'children' => [],
            ],
        ],
    ],    
];
