-- 2025-10-01_002_positions_orientacion_tipo.sql
-- SOL - Sistema de Operaciones Logísticas
-- Migración: Campos de orientación y tipo de ambiente en wh_positions

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- Orientación de la “cara” de la posición para render del layout:
--   N (arriba), E (derecha), S (abajo), W (izquierda)
-- Tipo de ambiente/zona por posición: SECO, FRIO, OTRO
ALTER TABLE `wh_positions`
  ADD COLUMN `orientacion` ENUM('N','E','S','W') NOT NULL DEFAULT 'N' AFTER `fondo`,
  ADD COLUMN `tipo_ambiente` ENUM('SECO','FRIO','OTRO') NOT NULL DEFAULT 'SECO' AFTER `orientacion`;

-- Índices útiles para filtros de layout y reportes
ALTER TABLE `wh_positions`
  ADD KEY `ix_pos_orientacion` (`orientacion`),
  ADD KEY `ix_pos_tipo_ambiente` (`tipo_ambiente`);

SET FOREIGN_KEY_CHECKS = 1;

-- Notas:
-- - Las filas existentes quedan con valores por defecto: orientacion='N', tipo_ambiente='SECO'.
-- - Estos campos podrán editarse desde el builder/visor en el siguiente paso.
