-- Migration: Add cliente_id to pl_packinglist and FK to para_clientes
-- Keeps cliente_ref for backward compatibility. New code should prefer cliente_id when present.

START TRANSACTION;

ALTER TABLE pl_packinglist
  ADD COLUMN cliente_id INT NULL AFTER cliente_ref;

-- Index and FK (ON DELETE SET NULL to avoid cascade deletes)
ALTER TABLE pl_packinglist
  ADD INDEX idx_pl_cliente_id (cliente_id),
  ADD CONSTRAINT fk_pl_packinglist_para_clientes FOREIGN KEY (cliente_id) REFERENCES para_clientes(id) ON DELETE SET NULL ON UPDATE CASCADE;

COMMIT;

-- Optional: Backfill heuristic (RUN MANUALLY AFTER REVIEW)
-- UPDATE pl_packinglist p
-- JOIN para_clientes c ON (c.ruc IS NOT NULL AND p.cliente_ref = c.ruc)
-- SET p.cliente_id = c.id
-- WHERE p.cliente_id IS NULL;

-- Alternative heuristic: if cliente_ref is numeric and corresponds to a para_clientes.id
-- UPDATE pl_packinglist p
-- JOIN para_clientes c ON CAST(p.cliente_ref AS UNSIGNED) = c.id
-- SET p.cliente_id = c.id
-- WHERE p.cliente_id IS NULL AND p.cliente_ref REGEXP '^[0-9]+';
