-- Migration: añadir columnas opcionales a pl_ingreso para metadata de recepción
-- Fecha: 2025-10-10
SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- Añadimos columnas no obligatorias para enlazar responsable, autorizado, cliente y estados
ALTER TABLE IF EXISTS pl_ingreso
  ADD COLUMN IF NOT EXISTS cliente_id INT UNSIGNED NULL AFTER packinglist_id,
  ADD COLUMN IF NOT EXISTS responsable_id INT UNSIGNED NULL AFTER chofer_id,
  ADD COLUMN IF NOT EXISTS autorizado_id INT UNSIGNED NULL AFTER responsable_id,
  ADD COLUMN IF NOT EXISTS estado_id INT UNSIGNED NULL AFTER autorizado_id,
  ADD COLUMN IF NOT EXISTS operario_id INT UNSIGNED NULL AFTER estado_id;

-- Índices para consultas rápidas
ALTER TABLE IF EXISTS pl_ingreso
  ADD INDEX IF NOT EXISTS idx_ing_cliente (cliente_id),
  ADD INDEX IF NOT EXISTS idx_ing_responsable (responsable_id);

SET FOREIGN_KEY_CHECKS = 1;

-- Nota: no se crean constraints FK por compatibilidad con entornos que no tengan
-- las tablas referenciadas. Las relaciones (si se desean) pueden añadirse manualmente.
