-- Migration: crear tabla recepcion_hdr y vincular a pl_rcv_link (opcional)
-- Fecha: 2025-10-10
SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- Tabla de cabecera de recepciones (una por evento físico de recepción)
DROP TABLE IF EXISTS recepcion_hdr;
CREATE TABLE recepcion_hdr (
  id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
  packinglist_id BIGINT UNSIGNED NOT NULL,
  fecha_ingreso DATE NULL,
  llegada_at DATETIME NULL,
  descarga_inicio_at DATETIME NULL,
  descarga_fin_at DATETIME NULL,
  movil_id INT UNSIGNED NULL,
  chofer_id INT UNSIGNED NULL,
  operarios_cant SMALLINT UNSIGNED NULL,
  doc_tipo ENUM('FACTURA','REMITO','OTRO') NULL,
  doc_numero VARCHAR(64) NULL,
  observacion VARCHAR(255) NULL,
  cliente_id INT UNSIGNED NULL,
  responsable_id INT UNSIGNED NULL,
  autorizado_id INT UNSIGNED NULL,
  operario_id INT UNSIGNED NULL,
  estado_id INT UNSIGNED NULL,
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  created_by BIGINT UNSIGNED NULL,
  updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Añadir columna recepcion_id a pl_rcv_link para referencia opcional
ALTER TABLE pl_rcv_link
  ADD COLUMN IF NOT EXISTS recepcion_id BIGINT UNSIGNED NULL AFTER move_id,
  ADD INDEX IF NOT EXISTS idx_rcv_recepcion (recepcion_id);

SET FOREIGN_KEY_CHECKS = 1;

-- Nota: no se añaden FKs para evitar problemas en instalaciones existentes. Si lo deseas,
-- podemos agregar: ALTER TABLE pl_rcv_link ADD CONSTRAINT fk_rcv_recepcion FOREIGN KEY (recepcion_id) REFERENCES recepcion_hdr(id) ON DELETE SET NULL;
