/*
 * Add cliente_id to wh_pallet so receipts can persist the client per pallet.
 * Run this migration in your development DB before deploying to production.
 */

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- Add columna cliente_id sólo si no existe
SELECT COUNT(*) INTO @col_exists FROM INFORMATION_SCHEMA.COLUMNS
 WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'wh_pallet' AND COLUMN_NAME = 'cliente_id';
SET @sql = IF(@col_exists = 0,
  'ALTER TABLE `wh_pallet` ADD COLUMN `cliente_id` INT UNSIGNED NULL AFTER `deposito_id`',
  'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add index and FK (only if para_clientes exists)
-- Add index only if not exists
SELECT COUNT(*) INTO @idx_exists FROM INFORMATION_SCHEMA.STATISTICS
 WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'wh_pallet' AND INDEX_NAME = 'idx_wh_pallet_cliente';
SET @sql2 = IF(@idx_exists = 0,
  'ALTER TABLE `wh_pallet` ADD INDEX `idx_wh_pallet_cliente` (`cliente_id`)',
  'SELECT 1');
PREPARE stmt2 FROM @sql2;
EXECUTE stmt2;
DEALLOCATE PREPARE stmt2;

-- If para_clientes table exists in your schema, you can add the FK constraint.
-- Uncomment the following line if you want the FK enforced (ensure para_clientes.id exists):
-- ALTER TABLE IF EXISTS `wh_pallet` ADD CONSTRAINT `fk_wh_pallet_cliente` FOREIGN KEY (`cliente_id`) REFERENCES `para_clientes` (`id`);

SET FOREIGN_KEY_CHECKS = 1;
