-- Migration: disponibilidad de móviles por día
CREATE TABLE IF NOT EXISTS oper_movil_disponible (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  fecha DATE NOT NULL,
  movil_id INT UNSIGNED NOT NULL,
  disponible TINYINT(1) NOT NULL DEFAULT 1,
  ventana_ini TIME NULL,
  ventana_fin TIME NULL,
  notas VARCHAR(255) NULL,
  created_at TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  UNIQUE KEY uniq_fecha_movil (fecha, movil_id),
  KEY idx_fecha (fecha),
  KEY idx_movil (movil_id),
  CONSTRAINT fk_oper_movil_disponible_movil FOREIGN KEY (movil_id) REFERENCES para_moviles(id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;