-- Migration: create table for seguimiento por destinatario en embarques
CREATE TABLE IF NOT EXISTS so_embarque_seguimiento_dest (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  embarque_id INT UNSIGNED NOT NULL,
  destinatario_id INT UNSIGNED NOT NULL,
  inicio_carga VARCHAR(20) NULL,
  fin_carga VARCHAR(20) NULL,
  km_inicial INT NULL,
  km_llegada INT NULL,
  hr_llegada VARCHAR(20) NULL,
  hr_inicio VARCHAR(20) NULL,
  espera_descargar VARCHAR(20) NULL,
  hr_termino VARCHAR(20) NULL,
  tiempo_descarga VARCHAR(20) NULL,
  hr_salida VARCHAR(20) NULL,
  tiempo_control VARCHAR(20) NULL,
  tiempo_total VARCHAR(20) NULL,
  tipo_carga VARCHAR(50) NULL,
  salida_camara VARCHAR(10) NULL,
  temp_carga_c DECIMAL(5,2) NULL,
  temp_desc_c DECIMAL(5,2) NULL,
  aviso_quien VARCHAR(100) NULL,
  aviso_hora VARCHAR(20) NULL,
  problema TEXT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  UNIQUE KEY uniq_emb_dest (embarque_id, destinatario_id),
  KEY idx_embarque (embarque_id),
  KEY idx_destinatario (destinatario_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;