ALTER TABLE so_embarque_devoluciones
  ADD COLUMN IF NOT EXISTS factura VARCHAR(100) NULL AFTER embarque_id;

ALTER TABLE so_embarque_devoluciones
  MODIFY COLUMN sku VARCHAR(100) NULL;

SET @idx_exists := (
  SELECT COUNT(1)
    FROM INFORMATION_SCHEMA.STATISTICS
   WHERE TABLE_SCHEMA = DATABASE()
     AND TABLE_NAME = 'so_embarque_devoluciones'
     AND INDEX_NAME = 'idx_so_embarque_devoluciones_factura'
);
SET @stmt := IF(@idx_exists = 0,
  'ALTER TABLE so_embarque_devoluciones ADD INDEX idx_so_embarque_devoluciones_factura (factura)',
  'SELECT 1'
);
PREPARE stmt FROM @stmt;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
