START TRANSACTION;

SET @finOrden := (SELECT orden FROM so_embarque_estado WHERE code = 'FINALIZADO' LIMIT 1);
UPDATE so_embarque_estado
   SET orden = @finOrden + 1
 WHERE code = 'FINALIZADO' AND @finOrden IS NOT NULL;

SET @vueltaOrden := IFNULL(@finOrden, 99);
INSERT INTO so_embarque_estado (code, nombre, orden, activo)
VALUES ('VUELTA', 'Vuelta', @vueltaOrden, 1)
ON DUPLICATE KEY UPDATE
  nombre = VALUES(nombre),
  activo = VALUES(activo),
  orden = @vueltaOrden;

COMMIT;
