-- Crear tabla para registrar errores en la preparación de pedidos
CREATE TABLE IF NOT EXISTS `so_pre_error_log` (
  `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  `so_id` BIGINT UNSIGNED NOT NULL,
  `pre_id` BIGINT UNSIGNED DEFAULT NULL,
  `motivo_id` INT UNSIGNED NOT NULL,
  `responsable_user_id` INT UNSIGNED DEFAULT NULL,
  `responsable_nombre` VARCHAR(190) DEFAULT NULL,
  `observacion` TEXT DEFAULT NULL,
  `logged_at` DATETIME NOT NULL,
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_so_pre_error_log_so` (`so_id`),
  KEY `idx_so_pre_error_log_pre` (`pre_id`),
  KEY `idx_so_pre_error_log_motivo` (`motivo_id`),
  KEY `idx_so_pre_error_log_logged_at` (`logged_at`),
  CONSTRAINT `fk_so_pre_error_log_so` FOREIGN KEY (`so_id`) REFERENCES `so_pedido`(`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_so_pre_error_log_motivo` FOREIGN KEY (`motivo_id`) REFERENCES `para_motivos_errores`(`id`) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
