-- database/migrations/20251007_fix_trg_pl_import_rows_ad.sql
-- Corrige creación del trigger con DELIMITER y borrado seguro

SET NAMES utf8mb4;
SET @OLD_SQL_MODE := @@SQL_MODE;
SET SQL_MODE = 'STRICT_ALL_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION';

DELIMITER $$

DROP TRIGGER IF EXISTS trg_pl_import_rows_ad $$
CREATE TRIGGER trg_pl_import_rows_ad
AFTER DELETE ON pl_import_rows
FOR EACH ROW
BEGIN
  DECLARE v_rownum INT;
  DECLARE v_del_id BIGINT UNSIGNED;

  SET v_rownum := OLD.fila_nro;

  IF v_rownum IS NOT NULL THEN
    -- Borrado directo por rownum dentro del mismo batch
    DELETE FROM pl_import_row
     WHERE batch_id = OLD.batch_id
       AND rownum   = v_rownum
     LIMIT 1;
  ELSE
    -- Fallback: localizar una fila candidata por sku (y lote si existe) y eliminar por id (evita error 1093)
    SELECT pir.id
      INTO v_del_id
      FROM pl_import_row pir
     WHERE pir.batch_id = OLD.batch_id
       AND JSON_UNQUOTE(JSON_EXTRACT(pir.raw,'$.sku_cliente')) = OLD.sku
       AND (JSON_UNQUOTE(JSON_EXTRACT(pir.raw,'$.lote')) <=> OLD.lote)
     ORDER BY pir.id
     LIMIT 1;

    IF v_del_id IS NOT NULL THEN
      DELETE FROM pl_import_row WHERE id = v_del_id;
    END IF;
  END IF;
END $$

DELIMITER ;

-- Restaurar SQL_MODE
SET SQL_MODE := @OLD_SQL_MODE;
