-- Create compatibility views for legacy warehouse tables
SET @OLD_SQL_MODE := @@SQL_MODE;
SET SQL_MODE = 'STRICT_ALL_TABLES,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION';

DROP VIEW IF EXISTS wh_positions;
CREATE VIEW wh_positions AS
SELECT
    p.id,
    p.deposito_id,
    p.rack,
    p.columna,
    p.nivel,
    p.fondo,
    p.orientacion,
    CASE
        WHEN a.code IN ('SECO','FRIO','OTRO','CUARENTENA') THEN a.code
        WHEN a.code IN ('PICKING','PREP','PREPARACION','PICK') THEN 'OTRO'
        ELSE 'OTRO'
    END AS tipo_ambiente,
    CAST(p.capacidad_pallets AS UNSIGNED) AS capacidad_pallets,
    p.activo,
    NULL AS nota,
    NULL AS created_by,
    NULL AS updated_by,
    p.created_at,
    p.updated_at
FROM wh_posicion p
LEFT JOIN wh_ambiente a ON a.id = p.ambiente_id;

DROP VIEW IF EXISTS wh_pallets;
CREATE VIEW wh_pallets AS
SELECT
    pal.id,
    pal.codigo,
    pal.deposito_id,
    pal.cliente_id,
    pal.posicion_id,
    pal.estado_id,
    pal.pickeado,
    pal.reservado,
    pal.peso_bruto_kg,
    pal.volumen_m3,
    pal.observacion,
    pal.created_at,
    pal.updated_at
FROM wh_pallet pal;

DROP VIEW IF EXISTS wh_pallet_items;
CREATE VIEW wh_pallet_items AS
SELECT
    item.id,
    item.pallet_id,
    item.producto_id,
    item.lote_id,
    item.uv_cajas,
    item.uc_unidades,
    item.peso_bruto_kg,
    item.created_at,
    item.updated_at
FROM wh_pallet_item item;

DROP VIEW IF EXISTS wh_moves;
CREATE VIEW wh_moves AS
SELECT
    mov.id,
    mov.deposito_id,
    mov.tipo,
    mov.motivo,
    mov.pallet_id,
    mov.producto_id,
    mov.lote_id,
    mov.from_pos_id,
    mov.to_pos_id,
    mov.delta_uv,
    mov.delta_uc,
    mov.created_at
FROM wh_move mov;

DROP VIEW IF EXISTS wh_position_occupancy;
CREATE VIEW wh_position_occupancy AS
SELECT
    s.posicion_id AS position_id,
    SUM(s.qty_uv) AS total_uv,
    SUM(s.qty_uc) AS total_uc,
    COUNT(DISTINCT s.pallet_id) AS pallets_count,
    MAX(s.updated_at) AS last_update
FROM wh_stock s
GROUP BY s.posicion_id;

SET SQL_MODE := @OLD_SQL_MODE;
