-- Rename packaging unit columns to use unified terminology (unidades_por_uv)

START TRANSACTION;

ALTER TABLE `para_producto_paletizado`
    CHANGE COLUMN `uc_por_caja` `unidades_por_uv` INT UNSIGNED DEFAULT NULL;

ALTER TABLE `para_producto_pack`
    CHANGE COLUMN `unidades_por_uc` `unidades_por_uv` INT UNSIGNED DEFAULT NULL,
    MODIFY COLUMN `precio_uv_efectivo_gs` DECIMAL(18,2) GENERATED ALWAYS AS (
        CASE
            WHEN `unidades_por_uv` IS NULL OR `unidades_por_uv` = 0 OR `precio_uc_efectivo_gs` IS NULL THEN NULL
            ELSE ROUND(`precio_uc_efectivo_gs` / `unidades_por_uv`, 2)
        END
    ) STORED;

COMMIT;
