-- ============================================================================
-- SOL - Sistema de Operaciones Logísticas
-- Módulo: Inventario / Conteo
-- Fecha: 2025-11-04
-- ============================================================================

-- Tabla principal de conteos de inventario
DROP TABLE IF EXISTS `inv_conteo_items`;
DROP TABLE IF EXISTS `inv_conteos`;

CREATE TABLE `inv_conteos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `codigo` varchar(32) NOT NULL COMMENT 'Código único del conteo (ej: CNT-20251104-001)',
  `fecha_conteo` date NOT NULL COMMENT 'Fecha de la toma física',
  `deposito_id` int unsigned NOT NULL COMMENT 'Depósito donde se realiza el conteo',
  `cliente_id` int unsigned DEFAULT NULL COMMENT 'Cliente específico (NULL = todos)',
  `estado` enum('BORRADOR','EN_PROCESO','FINALIZADO','APROBADO','RECHAZADO') NOT NULL DEFAULT 'BORRADOR',
  `tipo` enum('CICLICO','GENERAL','PARCIAL') NOT NULL DEFAULT 'GENERAL' COMMENT 'Tipo de conteo',
  `observaciones` text COMMENT 'Observaciones generales del conteo',
  `aprobado_por` int unsigned DEFAULT NULL COMMENT 'Usuario que aprobó',
  `aprobado_at` datetime DEFAULT NULL COMMENT 'Fecha de aprobación',
  `user_id` int unsigned NOT NULL COMMENT 'Usuario que creó el conteo',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_inv_conteos_codigo` (`codigo`),
  KEY `idx_inv_conteos_fecha` (`fecha_conteo`),
  KEY `idx_inv_conteos_deposito` (`deposito_id`),
  KEY `idx_inv_conteos_cliente` (`cliente_id`),
  KEY `idx_inv_conteos_estado` (`estado`),
  KEY `idx_inv_conteos_deleted` (`deleted_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Cabecera de conteos de inventario';

-- Tabla de detalle de items contados
CREATE TABLE `inv_conteo_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `conteo_id` bigint unsigned NOT NULL COMMENT 'Referencia al conteo',
  `producto_id` bigint unsigned NOT NULL COMMENT 'SKU contado',
  `lote_id` bigint unsigned DEFAULT NULL COMMENT 'Lote específico (NULL = sin lote)',
  `posicion_id` bigint unsigned DEFAULT NULL COMMENT 'Posición donde se encontró',
  `cantidad_pallets` int unsigned NOT NULL DEFAULT 0 COMMENT 'Número de pallets completos',
  `cantidad_cajas` int unsigned NOT NULL DEFAULT 0 COMMENT 'Cajas sueltas (UV)',
  `cantidad_unidades` int unsigned NOT NULL DEFAULT 0 COMMENT 'Unidades sueltas (UC)',
  `total_unidades` int unsigned NOT NULL DEFAULT 0 COMMENT 'Total convertido a unidades base',
  `unidades_por_caja` int unsigned DEFAULT NULL COMMENT 'UC por caja del producto (para cálculo)',
  `cajas_por_pallet` int unsigned DEFAULT NULL COMMENT 'Cajas por pallet del producto (para cálculo)',
  `observaciones` varchar(255) DEFAULT NULL COMMENT 'Notas sobre este item',
  `contado_por` int unsigned DEFAULT NULL COMMENT 'Usuario que realizó el conteo físico',
  `contado_at` datetime DEFAULT NULL COMMENT 'Momento del conteo',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_conteo_items_conteo` (`conteo_id`),
  KEY `idx_conteo_items_producto` (`producto_id`),
  KEY `idx_conteo_items_lote` (`lote_id`),
  KEY `idx_conteo_items_posicion` (`posicion_id`),
  KEY `idx_conteo_items_deleted` (`deleted_at`),
  CONSTRAINT `fk_conteo_items_conteo` FOREIGN KEY (`conteo_id`) REFERENCES `inv_conteos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Detalle de items contados en inventario';

-- Índice compuesto para evitar duplicados
CREATE UNIQUE INDEX `uq_conteo_producto_lote_pos` ON `inv_conteo_items` 
  (`conteo_id`, `producto_id`, `lote_id`, `posicion_id`, `deleted_at`);
