-- Estado inicial del pedido
SET @estado_rec = (SELECT id FROM so_pedido_estado WHERE code='RECIBIDO' LIMIT 1);

-- Crear pedido
INSERT INTO so_pedido (codigo, cliente_ref, fecha_pedido, estado_id)
VALUES ('SO-0004','CLI-ACME', CURDATE(), @estado_rec);
SET @ped := LAST_INSERT_ID();

-- Destinatarios (requiere para_destinatarios)
SET @destA := (SELECT id FROM para_destinatarios ORDER BY id LIMIT 1);
SET @destB := (SELECT id FROM para_destinatarios ORDER BY id LIMIT 1 OFFSET 1);

INSERT INTO so_pedido_dest (pedido_id, destinatario_id, doc_tipo, doc_numero)
VALUES
(@ped, @destA, 'FACTURA', 'F001-000123'),
(@ped, @destB, 'REMITO',  'R002-004567');
SET @pdA := LAST_INSERT_ID();
SET @pdB := @pdA + 1;

-- Productos (usa para_productos ya existentes)
SET @prod1 := (SELECT id FROM para_productos ORDER BY id LIMIT 1);
SET @prod2 := (SELECT id FROM para_productos ORDER BY id LIMIT 1 OFFSET 1);

INSERT INTO so_pedido_dest_item (pedido_dest_id, producto_id, lote_codigo, expected_uv, expected_uc)
VALUES
(@pdA, @prod1, NULL, 10,  0),
(@pdA, @prod2, 'L-XYZ', 0, 50),
(@pdB, @prod1, NULL,  5,  0);



-- Prepara automáticamente todo lo pendiente hacia PREP (elige zona auto)
CALL sp_so_preparar_auto('SO-0004','DEP1', NULL);

-- Ver totales y pendientes
SELECT * FROM v_so_pedido_resumen WHERE pedido_codigo='SO-0004';


-- Prepara automáticamente todo lo pendiente hacia PREP (elige zona auto)
CALL sp_so_preparar_auto('SO-0004','DEP1', NULL);

-- Ver totales y pendientes
SELECT * FROM v_so_pedido_resumen WHERE pedido_codigo='SO-0004';


SET @dev = JSON_ARRAY(
  JSON_OBJECT('destinatario_id', (SELECT destinatario_id FROM so_embarque_parada WHERE embarque_id=(SELECT id FROM so_embarque WHERE codigo='EMB-0001') LIMIT 1),
              'doc_tipo','FACTURA','doc_numero','F001-000123','motivo_code','CLIENTE_RECHAZA',
              'producto_id', (SELECT producto_id FROM so_pedido_dest_item i JOIN so_pedido_dest d ON d.id=i.pedido_dest_id JOIN so_pedido p ON p.id=d.pedido_id WHERE p.codigo='SO-0004' LIMIT 1),
              'lote_codigo', NULL, 'uv', 1, 'uc', 0)
);

CALL sp_so_retorno_y_devoluciones('EMB-0001', NOW(), @dev);

-- Ver devoluciones
SELECT * FROM v_so_devoluciones WHERE embarque='EMB-0001';
