-- Cabecera
INSERT INTO pl_packinglist (codigo, cliente_ref, fecha, estado)
VALUES ('PL-0104', 'CLI-ACME', CURDATE(), 'IMPORTADO');

SET @pl := LAST_INSERT_ID();

-- Líneas (esperadas)
INSERT INTO pl_packinglist_item (packinglist_id, sku_cliente, producto_id, descripcion, expected_uv, expected_uc)
VALUES
(@pl,'SKU-ACME-101',1,'Producto A',10,0),
(@pl,'SKU-ACME-102',2,'Producto B',5,12);


INSERT INTO pl_movil (patente, empresa) VALUES ('ABC123', 'Trans ACME')
ON DUPLICATE KEY UPDATE empresa=VALUES(empresa);
SET @movil := (SELECT id FROM pl_movil WHERE patente='ABC123');

INSERT INTO pl_chofer (nombre, doc_numero) VALUES ('Pedro Pérez', '2222')
ON DUPLICATE KEY UPDATE doc_numero=VALUES(doc_numero);
SET @chofer := (SELECT id FROM pl_chofer WHERE doc_numero='2222');

SET @dep := (SELECT id FROM wh_deposito WHERE code='DEP1');

INSERT INTO pl_ingreso
  (packinglist_id, deposito_id, movil_id, chofer_id, fecha_ingreso, llegada_at, descarga_inicio_at, operarios_cant, doc_tipo, doc_numero)
VALUES
  (@pl, @dep, @movil, @chofer, CURDATE(), NOW(), NOW(), 4, 'REMITO', 'R-12345');

-- Recibir 8 cajas del Producto A en un pallet (CUARENTENA auto)
CALL sp_wh_ingreso_create(
  'DEP1','PAL-PL0105-A', NULL, 'CUARENTENA',
  JSON_ARRAY(JSON_OBJECT('producto_id',1,'lote_codigo','L-PL-A','uv_cajas',8,'uc_unidades',0)),
  0
);
SET @pal_a := (SELECT id FROM wh_pallet WHERE codigo='PAL-PL0105-A');
SET @move_a := (SELECT MAX(id) FROM wh_move WHERE pallet_id=@pal_a);
SET @lote_a := (SELECT id FROM wh_lote WHERE producto_id=1 AND codigo='L-PL-A');

-- Enlazar esa recepción a la línea del PL (dispara trigger y suma recibidos)
SET @pl_item_a := (SELECT id FROM pl_packinglist_item WHERE packinglist_id=@pl AND producto_id=1);
INSERT INTO pl_rcv_link (packinglist_id, pl_item_id, producto_id, lote_id, pallet_id, move_id, uv_cajas, uc_unidades)
VALUES (@pl, @pl_item_a, 1, @lote_a, @pal_a, @move_a, 8, 0);
