INSERT INTO pl_import_batch (tipo, filename, sheet_name)
VALUES ('PACKINGLIST', 'PL_0002.xlsx', 'Hoja1');
SET @batch := LAST_INSERT_ID();

INSERT INTO pl_import_row (batch_id, rownum, raw) VALUES
(@batch, 1, JSON_OBJECT('sku_cliente','SKU-NEW-001','descripcion','Producto nuevo A','expected_uv',12,'expected_uc',0,'lote_codigo','L-A','fecha_produccion','2025-09-01','fecha_vencimiento','2026-09-01')),
(@batch, 2, JSON_OBJECT('sku_cliente','SKU-ACME-002','descripcion','Producto B (cliente)','uv',5,'uc',12));


CALL sp_pl_import_packinglist_from_batch(
  @batch, 'CLI-ACME', 'PL-0002', CURDATE(), 1, @pl_out
);
SELECT @pl_out AS packinglist_id;


SELECT * FROM pl_packinglist WHERE id=@pl_out;
SELECT id, sku_cliente, producto_id, descripcion, lote_codigo, expected_uv, expected_uc
FROM pl_packinglist_item
WHERE packinglist_id=@pl_out;

SELECT * FROM pl_producto_alias WHERE cliente_ref='CLI-ACME';
SELECT id, denominacion FROM para_productos ORDER BY id DESC LIMIT 5;

SELECT * FROM pl_import_batch WHERE id=@batch;
SELECT id, rownum, status, error_msg, item_id FROM pl_import_row WHERE batch_id=@batch;

SELECT * FROM v_pl_resumen WHERE packinglist_id=@pl_out;
SELECT * FROM v_pl_item_resumen WHERE packinglist_id=@pl_out;
