-- 1) Semilla mínima (pedido con 2 destinatarios e ítems)
-- Estado inicial del pedido
SET @estado_rec = (SELECT id FROM so_pedido_estado WHERE code='RECIBIDO' LIMIT 1);

-- Crear pedido
INSERT INTO so_pedido (codigo, cliente_ref, fecha_pedido, estado_id)
VALUES ('SO-0002','CLI-ACME', CURDATE(), @estado_rec);
SET @ped := LAST_INSERT_ID();

-- Destinatarios (requiere para_destinatarios)
SET @destA := (SELECT id FROM para_destinatarios ORDER BY id LIMIT 1);
SET @destB := (SELECT id FROM para_destinatarios ORDER BY id LIMIT 1 OFFSET 1);

INSERT INTO so_pedido_dest (pedido_id, destinatario_id, doc_tipo, doc_numero)
VALUES
(@ped, @destA, 'FACTURA', 'F001-000123'),
(@ped, @destB, 'REMITO',  'R002-004567');
SET @pdA := LAST_INSERT_ID();
SET @pdB := @pdA + 1;

-- Productos (usa para_productos ya existentes)
SET @prod1 := (SELECT id FROM para_productos ORDER BY id LIMIT 1);
SET @prod2 := (SELECT id FROM para_productos ORDER BY id LIMIT 1 OFFSET 1);

INSERT INTO so_pedido_dest_item (pedido_dest_id, producto_id, lote_codigo, expected_uv, expected_uc)
VALUES
(@pdA, @prod1, NULL, 10,  0),
(@pdA, @prod2, 'L-XYZ', 0, 50),
(@pdB, @prod1, NULL,  5,  0);


-- 2) Crear pre-embarque y una tarea de montacarga
SET @dep1 := (SELECT id FROM wh_deposito WHERE code='DEP1');
SET @pre_est := (SELECT id FROM so_preembarque_estado WHERE code='PENDIENTE');

INSERT INTO so_preembarque (codigo, pedido_id, deposito_id, estado_id, asignado_at)
VALUES ('PRE-0001', @ped, @dep1, @pre_est, NOW());
SET @pre := LAST_INSERT_ID();

INSERT INTO so_pre_tarea (preembarque_id, tipo, inicio_at)
VALUES (@pre, 'MONTACARGA', NOW());


-- 3) Embarque y ruteo (sin movimientos aún)

SET @emb_est := (SELECT id FROM so_embarque_estado WHERE code='EN_COLA');
INSERT INTO so_embarque (codigo, deposito_id, estado_id, llegada_at)
VALUES ('EMB-0001', @dep1, @emb_est, NOW());
SET @emb := LAST_INSERT_ID();

-- Asignar el pre-embarque creado
INSERT INTO so_embarque_pre (embarque_id, preembarque_id) VALUES (@emb, @pre);

-- Paradas (usar los mismos destinatarios del pedido)
INSERT INTO so_embarque_parada (embarque_id, destinatario_id, pedido_dest_id, orden, hora_llegada)
VALUES
(@emb, @destA, @pdA, 1, NOW()),
(@emb, @destB, @pdB, 2, DATE_ADD(NOW(), INTERVAL 90 MINUTE));
