(function () {
	if (!window.feather || typeof window.feather.replace !== 'function') {
		return;
	}

	var nodes = document.querySelectorAll('[data-feather]');
	var missing = [];

	nodes.forEach(function (el) {
		var icon = (el.getAttribute('data-feather') || '').trim();
		if (!icon) {
			el.removeAttribute('data-feather');
			return;
		}
		if (!window.feather.icons || !window.feather.icons[icon]) {
			missing.push(icon);
			el.removeAttribute('data-feather');
		}
	});

	if (missing.length) {
		var unique = Array.from(new Set(missing));
		console.warn('Iconos Feather no encontrados:', unique);
	}

	window.feather.replace();
})();