/* public/assets/js/theme/auto-select2.js */
(function () {
  if (!window.jQuery) return;
  const $ = window.jQuery;

  // i18n ES
  const i18nEs = {
    errorLoading: () => 'No se pudieron cargar los resultados.',
    inputTooLong: (args) => `Por favor, elimine ${args.input.length - args.maximum} carácter(es).`,
    inputTooShort: (args) => `Por favor, ingrese ${args.minimum - args.input.length} carácter(es) más.`,
    loadingMore: () => 'Cargando más resultados…',
    maximumSelected: (args) => `Solo puede seleccionar ${args.maximum} elemento(s).`,
    noResults: () => 'No se encontraron resultados',
    searching: () => 'Buscando…',
    removeAllItems: () => 'Eliminar todos los elementos',
  };

  function dropdownParent($el) {
    const $wrap = $el.closest('.modal, .DTE'); // Bootstrap modal o DataTables Editor
    return $wrap.length ? $wrap : $(document.body);
  }

  function enhance(root) {
    if (!$.fn.select2) {
      console.error('Select2 no está cargado');
      return;
    }
    $(root).find('select.form-select:not(.no-select2)').each(function () {
      const $el = $(this);
      if ($el.hasClass('select2-hidden-accessible')) return; // ya inicializado

      const placeholder = $el.attr('placeholder') || $el.data('placeholder') || '';
      const allowClear  = !!$el.data('allowClear');

      $el.select2({
        width: '100%',
        language: i18nEs,
        dropdownParent: dropdownParent($el),
        minimumResultsForSearch: 0,   // SIEMPRE con buscador
        placeholder,
        allowClear,
      }).on('select2:open', () => {
        const $search = $('.select2-container--open .select2-search__field');
        if ($search.length) $search.trigger('focus');
      });
    });
  }

  // Init inicial
  $(function () { enhance(document); });

  // Al abrir modales Bootstrap
  $(document).on('shown.bs.modal', (ev) => enhance(ev.target));

  // Observa nodos dinámicos (tabs, Editor, AJAX, etc.)
  const mo = new MutationObserver((muts) => {
    for (const m of muts) for (const n of m.addedNodes) {
      if (n && n.nodeType === 1) enhance(n);
    }
  });
  mo.observe(document.body, { childList: true, subtree: true });
})();
