# Sistema de Conteo SOL

Sistema web de conteo optimizado para dispositivos móviles con gestión de depósitos y ambientes.

## 📁 Estructura del Proyecto

```
conteo/
├── assets/
│   ├── css/
│   │   └── styles.css          # Estilos compilados (NO EDITAR)
│   ├── js/
│   │   └── contador.js         # Lógica del contador
│   └── scss/
│       ├── _base.scss          # Estilos base y reset
│       ├── _colors.scss        # Paleta de colores
│       ├── _counter.scss       # Componente contador
│       ├── _forms.scss         # Elementos de formulario
│       ├── _header.scss        # Componente header
│       ├── _layout.scss        # Layout y cards
│       ├── _list.scss          # Listas de conteo
│       ├── _login.scss         # Página de login
│       ├── _utilities.scss     # Utilidades y animaciones
│       └── styles.scss         # Archivo principal SCSS
├── config/
│   └── config.php              # Configuración de BD y sesiones
├── scripts/
│   ├── check_table.php         # Verificar estructura de tabla
│   └── test_connection.php     # Probar conexión BD
├── conteo.php                  # Aplicación principal
└── index.php                   # Página de login
```

## 🎨 Paleta de Colores

- **Sky Blue** (#8ecae6ff) - Detalles y hover
- **Blue Green** (#219ebcff) - Color principal
- **Prussian Blue** (#023047ff) - Color secundario
- **Selective Yellow** (#ffb703ff) - Botón reset
- **UT Orange** (#fb8500ff) - Botón decremento

## 🚀 Uso

### Desarrollo de Estilos

1. Editar archivos SCSS en `assets/scss/`
2. Compilar a CSS:
   ```bash
   # Si tienes sass instalado
   sass assets/scss/styles.scss assets/css/styles.css
   ```
3. El archivo `assets/css/styles.css` se actualizará automáticamente

### Base de Datos

- **Database:** sol
- **Tabla usuarios:** sys_users
- **Tabla depósitos:** wh_deposito
- **Tabla ambientes:** wh_ambiente
- **Configuración:** `config/config.php`

### Scripts de Utilidad

- `scripts/check_table.php` - Ver estructura de la tabla sys_users
- `scripts/test_connection.php` - Probar conexión a la base de datos
- `scripts/check_warehouse.php` - Verificar tablas de depósitos y ambientes

## 📱 Características

- ✅ Diseño responsive móvil-first
- ✅ PWA-ready
- ✅ Bootstrap 5.3.2 con Bootstrap Icons
- ✅ Select2 4.1.0 con tema Bootstrap 5
- ✅ Selección de depósitos y ambientes desde BD
- ✅ Búsqueda y filtrado en selects
- ✅ Feedback háptico en dispositivos compatibles
- ✅ Atajos de teclado (+ / -)
- ✅ Animaciones suaves
- ✅ Sistema de autenticación

## 🔧 Configuración

Editar `config/config.php` para cambiar:
- Host de base de datos
- Nombre de base de datos
- Credenciales

## 📝 Notas

- Los estilos en línea han sido migrados a SCSS modular
- El JavaScript ha sido separado en archivos externos
- La configuración está centralizada en la carpeta `config/`
