# Select2 en Sistema SOL

## 🎯 Implementación Completa

### CDN Incluidos
- **jQuery 3.7.1** (requerido)
- **Select2 4.1.0**
- **Select2 Bootstrap 5 Theme 1.3.0**

### Archivos Creados
- `assets/scss/_select2.scss` - Estilos personalizados SCSS
- `assets/js/select2-init.js` - Inicialización y configuración
- `assets/css/styles.css` - Estilos compilados

## 🎨 Personalización con Paleta SOL

### Colores Aplicados:
- **Borde normal:** `#e0e0e0`
- **Borde activo:** `#219ebcff` (Blue Green)
- **Texto:** `#023047ff` (Prussian Blue)
- **Fondo seleccionado:** `#8ecae6ff` (Sky Blue)
- **Hover:** `#219ebcff` (Blue Green)
- **Tags:** `#8ecae6ff` con borde `#219ebcff`

## 🚀 Uso en el Código

### HTML
```html
<select id="deposito" class="form-select select2">
    <option value="">-- Seleccione --</option>
    <option value="1">Opción 1</option>
</select>
```

### JavaScript - Funciones Disponibles

#### Obtener valores seleccionados:
```javascript
const selection = getSelectedWarehouse();
console.log(selection.deposito);      // ID del depósito
console.log(selection.depositoText);  // Nombre del depósito
console.log(selection.ambiente);      // ID del ambiente
console.log(selection.ambienteText);  // Nombre del ambiente
```

#### Limpiar selecciones:
```javascript
clearWarehouseSelection();
```

#### Validar selecciones:
```javascript
if (validateWarehouseSelection()) {
    // Ambos selects tienen valor
    console.log('Validación exitosa');
}
```

## ⚙️ Configuración

### Opciones aplicadas:
- **theme:** `'bootstrap-5'`
- **placeholder:** Personalizado con emojis
- **allowClear:** `true` (permite limpiar)
- **minimumResultsForSearch:** `5` (búsqueda si hay >5 opciones)
- **language:** Español completo

### Eventos Disponibles:
```javascript
// Cuando se selecciona un valor
$('#deposito').on('select2:select', function(e) {
    var data = e.params.data;
    console.log(data.id, data.text);
});

// Cuando se limpia la selección
$('#deposito').on('select2:clear', function() {
    console.log('Deseleccionado');
});

// Cuando se abre el dropdown
$('#deposito').on('select2:open', function() {
    console.log('Abierto');
});

// Cuando se cierra el dropdown
$('#deposito').on('select2:close', function() {
    console.log('Cerrado');
});
```

## 📱 Responsive

### Ajustes para móvil:
- Altura mínima aumentada a `48px`
- Tamaño de fuente `16px` (evita zoom en iOS)
- Padding aumentado para mejor touch
- Búsqueda optimizada para pantallas pequeñas

## 🎨 Clases CSS Personalizadas

### Principales:
- `.select2-container--bootstrap-5` - Contenedor principal
- `.select2-selection` - Input/botón de selección
- `.select2-dropdown` - Lista desplegable
- `.select2-results__option` - Cada opción
- `.select2-search__field` - Campo de búsqueda

### Estados:
- `.select2-results__option--highlighted` - Opción con hover
- `.select2-results__option--selected` - Opción seleccionada
- `.select2-container--open` - Cuando está abierto

## 💡 Tips

1. **Recargar opciones dinámicamente:**
```javascript
$('#deposito').empty().append(/* nuevas opciones */).trigger('change');
```

2. **Establecer valor programáticamente:**
```javascript
$('#deposito').val('5').trigger('change');
```

3. **Deshabilitar/Habilitar:**
```javascript
$('#deposito').prop('disabled', true);  // Deshabilitar
$('#deposito').prop('disabled', false); // Habilitar
```

4. **Agregar clase personalizada:**
```javascript
$('#deposito').select2({
    dropdownCssClass: 'mi-clase-personalizada'
});
```

## 🐛 Troubleshooting

### El select no se inicializa:
- Verificar que jQuery esté cargado antes de Select2
- Verificar que el DOM esté listo (`$(document).ready()`)

### Los estilos no se aplican:
- Verificar orden de carga: Bootstrap CSS → Select2 CSS → Tema → Estilos custom
- Usar `!important` si es necesario

### El placeholder no aparece:
- Asegurar que la primera opción tenga `value=""`
- Configurar `placeholder` en las opciones de Select2

## 📚 Documentación Oficial
- [Select2 Docs](https://select2.org/)
- [Select2 Examples](https://select2.org/examples)
- [Bootstrap 5 Theme](https://github.com/apalfrey/select2-bootstrap-5-theme)
