<?php
/**
 * API para obtener racks de un depósito específico
 * Devuelve los racks únicos de wh_posicion filtrados por deposito_id
 */

header('Content-Type: application/json');
require_once '../config/config.php';

// Verificar que el usuario esté autenticado
verificarLogin();

try {
    $db = getDBConnection();

    // Obtener el deposito_id del parámetro GET
    $deposito_id = isset($_GET['deposito_id']) ? intval($_GET['deposito_id']) : 0;

    if ($deposito_id <= 0) {
        echo json_encode([
            'success' => false,
            'message' => 'ID de depósito no válido',
            'data' => []
        ]);
        exit;
    }

    // Consultar racks únicos del depósito seleccionado
    $stmt = $db->prepare("
        SELECT DISTINCT rack
        FROM wh_posicion
        WHERE deposito_id = :deposito_id
          AND activo = 1
        ORDER BY rack ASC
    ");

    $stmt->execute(['deposito_id' => $deposito_id]);
    $racks = $stmt->fetchAll(PDO::FETCH_COLUMN);

    // Log para debug
    error_log("Racks obtenidos para depósito $deposito_id: " . count($racks));

    echo json_encode([
        'success' => true,
        'message' => 'Racks cargados correctamente',
        'data' => $racks,
        'total' => count($racks)
    ]);

} catch (Exception $e) {
    error_log("Error obteniendo racks: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Error al cargar racks: ' . $e->getMessage(),
        'data' => []
    ]);
}
