/**
 * Sistema de Conteo - JavaScript
 * Manejo del contador y funcionalidad de la aplicación
 */

let counter = 0;

/**
 * Actualizar el display del contador
 */
function updateDisplay() {
  const counterElement = document.getElementById("counter");
  if (counterElement) {
    counterElement.textContent = counter;
  }
}

/**
 * Incrementar contador
 */
function increment() {
  counter++;
  updateDisplay();

  // Haptic feedback en móviles
  if (navigator.vibrate) {
    navigator.vibrate(10);
  }

  // Animación visual
  animateCounter();
}

/**
 * Decrementar contador
 */
function decrement() {
  if (counter > 0) {
    counter--;
    updateDisplay();

    if (navigator.vibrate) {
      navigator.vibrate(10);
    }

    animateCounter();
  }
}

/**
 * Reiniciar contador
 */
function resetCounter() {
  if (confirm("¿Está seguro de reiniciar el contador?")) {
    counter = 0;
    updateDisplay();
    animateCounter();
  }
}

/**
 * Animación del contador
 */
function animateCounter() {
  const counterElement = document.getElementById("counter");
  if (counterElement) {
    counterElement.style.transform = "scale(1.1)";
    setTimeout(() => {
      counterElement.style.transform = "scale(1)";
    }, 150);
  }
}

/**
 * Guardar conteo
 */
function saveConteo() {
  if (counter === 0) {
    alert("El contador está en 0. Incremente el valor antes de guardar.");
    return;
  }

  const descripcion = document.getElementById("descripcion").value;
  const notas = document.getElementById("notas").value;

  // Aquí irá la llamada AJAX para guardar en la base de datos
  // Por ahora solo mostramos un mensaje
  const mensaje = `Conteo guardado:\nValor: ${counter}\nDescripción: ${
    descripcion || "Sin descripción"
  }`;

  // TODO: Implementar AJAX
  console.log("Guardando conteo:", { counter, descripcion, notas });

  alert(mensaje);

  // Opcional: reiniciar después de guardar
  // counter = 0;
  // document.getElementById('descripcion').value = '';
  // document.getElementById('notas').value = '';
  // updateDisplay();
}

/**
 * Inicialización cuando el DOM está listo
 */
document.addEventListener("DOMContentLoaded", function () {
  // Atajos de teclado para desktop
  document.addEventListener("keydown", function (e) {
    if (e.key === "+" || e.key === "=") {
      e.preventDefault();
      increment();
    } else if (e.key === "-" || e.key === "_") {
      e.preventDefault();
      decrement();
    }
  });

  // Transición suave para el contador
  const counterElement = document.getElementById("counter");
  if (counterElement) {
    counterElement.style.transition = "transform 0.15s ease-out";
  }

  console.log("Sistema de Conteo inicializado");
});
