/**
 * Carga dinámica de racks según el depósito seleccionado
 */

const ambienteSelect = document.getElementById("ambiente");

// Cargar racks cuando se selecciona un depósito
document.getElementById("deposito").addEventListener("change", function () {
  const depositoId = this.value;
  const rackSelect = document.getElementById("rack");
  const rackCount = document.getElementById("rack-count");

  // Limpiar el select de racks
  rackSelect.innerHTML = '<option value="">-- Cargando racks... --</option>';
  rackSelect.disabled = true;

  if (ambienteSelect) {
    ambienteSelect.value = "";
  }

  // Ocultar layout al cambiar de depósito
  ocultarLayout();

  if (!depositoId) {
    rackSelect.innerHTML = '<option value="">-- Seleccione rack --</option>';
    if (rackCount) rackCount.textContent = "(seleccione depósito)";
    ocultarLayout(); // Ocultar layout si se deselecciona el depósito
    return;
  }

  // Vibración haptic
  if (navigator.vibrate) {
    navigator.vibrate(10);
  }

  console.log("📦 Cargando racks para depósito:", depositoId);

  // Hacer petición AJAX para obtener los racks
  fetch(`api/get_racks.php?deposito_id=${depositoId}`)
    .then((response) => response.json())
    .then((data) => {
      console.log("📊 Respuesta del servidor:", data);

      if (data.success && data.data.length > 0) {
        // Limpiar y agregar opción por defecto
        rackSelect.innerHTML =
          '<option value="">-- Seleccione rack --</option>';

        // Agregar cada rack como opción
        data.data.forEach((rack) => {
          const option = document.createElement("option");
          option.value = rack;
          option.textContent = `Rack ${rack}`;
          rackSelect.appendChild(option);
        });

        // Habilitar el select
        rackSelect.disabled = false;
        if (rackCount) rackCount.textContent = `(${data.total} disponibles)`;

        console.log(`✅ ${data.total} racks cargados correctamente`);
      } else {
        rackSelect.innerHTML =
          '<option value="">-- No hay racks disponibles --</option>';
        if (rackCount) rackCount.textContent = "(0 disponibles)";
        console.warn("⚠️ No se encontraron racks para este depósito");
      }
    })
    .catch((error) => {
      console.error("❌ Error cargando racks:", error);
      rackSelect.innerHTML =
        '<option value="">-- Error al cargar racks --</option>';
      if (rackCount) rackCount.textContent = "(error)";
    });
});

// Agregar feedback visual cuando se selecciona un rack
document.getElementById("rack").addEventListener("change", function () {
  if (this.value) {
    const rackValue = this.value;
    const depositoId = document.getElementById("deposito").value;
    const ambienteId = ambienteSelect ? ambienteSelect.value : "";

    console.log("🎯 Rack seleccionado:", rackValue);

    // Vibración haptic
    if (navigator.vibrate) {
      navigator.vibrate(10);
    }

    // Cargar posiciones del rack (función definida en rack-visualizer.js)
    if (typeof cargarPosicionesRack === "function") {
      cargarPosicionesRack(depositoId, rackValue, ambienteId);
    }
  } else {
    // Ocultar el layout si se deselecciona (función definida en rack-visualizer.js)
    if (typeof ocultarLayout === "function") {
      ocultarLayout();
    }
  }
});

// Filtrar posiciones por ambiente seleccionado
if (ambienteSelect) {
  ambienteSelect.addEventListener("change", function () {
    const depositoId = document.getElementById("deposito").value;
    const rackValue = document.getElementById("rack").value;
    const ambienteId = this.value;

    if (!depositoId || !rackValue) {
      if (typeof ocultarLayout === "function") {
        ocultarLayout();
      }
      return;
    }

    if (navigator.vibrate) {
      navigator.vibrate(10);
    }

    if (typeof cargarPosicionesRack === "function") {
      cargarPosicionesRack(depositoId, rackValue, ambienteId);
    }
  });
}

console.log("✅ Sistema de carga dinámica de racks inicializado");
