/**
 * Select2 Initialization and Configuration
 * Configuración de Select2 para el sistema SOL
 */

(function ($) {
  "use strict";

  // Configuración de idioma español para Select2
  const select2LanguageES = {
    errorLoading: function () {
      return "No se pudieron cargar los resultados";
    },
    inputTooLong: function (args) {
      var overChars = args.input.length - args.maximum;
      var message = "Por favor, elimine " + overChars + " caracter";
      if (overChars !== 1) {
        message += "es";
      }
      return message;
    },
    inputTooShort: function (args) {
      var remainingChars = args.minimum - args.input.length;
      var message =
        "Por favor, introduzca " + remainingChars + " o más caracteres";
      return message;
    },
    loadingMore: function () {
      return "Cargando más resultados...";
    },
    maximumSelected: function (args) {
      var message = "Sólo puede seleccionar " + args.maximum + " elemento";
      if (args.maximum !== 1) {
        message += "s";
      }
      return message;
    },
    noResults: function () {
      return "No se encontraron resultados";
    },
    searching: function () {
      return "Buscando...";
    },
    removeAllItems: function () {
      return "Eliminar todos los elementos";
    },
  };

  // Configuración por defecto para todos los Select2
  $.fn.select2.defaults.set("theme", "bootstrap-5");
  $.fn.select2.defaults.set("language", select2LanguageES);
  $.fn.select2.defaults.set("width", "100%");

  /**
   * Inicializar todos los selects con clase .select2
   */
  function initializeSelect2() {
    // Select de Depósito
    if ($("#deposito").length) {
      var depositoOptions = $("#deposito option").length;
      console.log(
        "📦 Depósito encontrado con " + depositoOptions + " opciones"
      );

      $("#deposito").select2({
        placeholder: "🏢 Seleccione un depósito",
        allowClear: true,
        minimumResultsForSearch: 5, // Mostrar búsqueda si hay más de 5 opciones
        language: select2LanguageES,
      });

      // Debug: mostrar opciones
      $("#deposito option").each(function (index) {
        if (index > 0) {
          // Saltar la primera opción vacía
          console.log(
            "  - Opción " +
              index +
              ": " +
              $(this).val() +
              " = " +
              $(this).text()
          );
        }
      });

      // Evento cuando cambia la selección
      $("#deposito").on("select2:select", function (e) {
        var data = e.params.data;
        console.log("✅ Depósito seleccionado:", data.id, data.text);

        // Vibración haptic en móviles
        if (navigator.vibrate) {
          navigator.vibrate(10);
        }
      });

      // Evento cuando se limpia la selección
      $("#deposito").on("select2:clear", function () {
        console.log("❌ Depósito deseleccionado");
      });
    } else {
      console.warn("⚠️ No se encontró el select #deposito");
    }

    // Select de Ambiente
    if ($("#ambiente").length) {
      var ambienteOptions = $("#ambiente option").length;
      console.log(
        "🏠 Ambiente encontrado con " + ambienteOptions + " opciones"
      );

      $("#ambiente").select2({
        placeholder: "🏠 Seleccione un ambiente",
        allowClear: true,
        minimumResultsForSearch: 5,
        language: select2LanguageES,
      });

      // Debug: mostrar opciones
      $("#ambiente option").each(function (index) {
        if (index > 0) {
          // Saltar la primera opción vacía
          console.log(
            "  - Opción " +
              index +
              ": " +
              $(this).val() +
              " = " +
              $(this).text()
          );
        }
      });

      // Evento cuando cambia la selección
      $("#ambiente").on("select2:select", function (e) {
        var data = e.params.data;
        console.log("✅ Ambiente seleccionado:", data.id, data.text);

        // Vibración haptic en móviles
        if (navigator.vibrate) {
          navigator.vibrate(10);
        }
      });

      // Evento cuando se limpia la selección
      $("#ambiente").on("select2:clear", function () {
        console.log("❌ Ambiente deseleccionado");
      });
    } else {
      console.warn("⚠️ No se encontró el select #ambiente");
    }

    // Inicializar cualquier otro select con clase .select2
    $(".select2:not(#deposito):not(#ambiente)").each(function () {
      $(this).select2({
        placeholder: $(this).data("placeholder") || "Seleccione una opción",
        allowClear: true,
        minimumResultsForSearch: 5,
        language: select2LanguageES,
      });
    });
  }

  /**
   * Obtener valores seleccionados
   */
  window.getSelectedWarehouse = function () {
    return {
      deposito: $("#deposito").val(),
      depositoText: $("#deposito option:selected").text(),
      ambiente: $("#ambiente").val(),
      ambienteText: $("#ambiente option:selected").text(),
    };
  };

  /**
   * Limpiar selecciones
   */
  window.clearWarehouseSelection = function () {
    $("#deposito").val(null).trigger("change");
    $("#ambiente").val(null).trigger("change");
  };

  /**
   * Validar que ambos selects tengan valor
   */
  window.validateWarehouseSelection = function () {
    const deposito = $("#deposito").val();
    const ambiente = $("#ambiente").val();

    if (!deposito) {
      alert("⚠️ Por favor seleccione un depósito");
      $("#deposito").select2("open");
      return false;
    }

    if (!ambiente) {
      alert("⚠️ Por favor seleccione un ambiente");
      $("#ambiente").select2("open");
      return false;
    }

    return true;
  };

  // Inicializar cuando el DOM esté listo
  $(document).ready(function () {
    initializeSelect2();
    console.log("✅ Select2 inicializado correctamente");
  });
})(jQuery);
