<?php
require_once 'config/config.php';
verificarLogin();

// Procesar logout
if (isset($_GET['logout'])) {
    logout();
}

$db = getDBConnection();
$user_id = $_SESSION['user_id'];
$username = $_SESSION['username'];
$nombre = $_SESSION['nombre'];

// Cargar depósitos
$depositos = [];
try {
    $stmt = $db->query("SELECT * FROM wh_deposito ORDER BY nombre");
    $depositos = $stmt->fetchAll();
    error_log("Depósitos cargados: " . count($depositos));
} catch (Exception $e) {
    // Si hay error, continuamos sin datos
    error_log("Error cargando depósitos: " . $e->getMessage());
}

// Cargar ambientes
$ambientes = [];
try {
    $stmt = $db->query("SELECT * FROM wh_ambiente ORDER BY nombre");
    $ambientes = $stmt->fetchAll();
    error_log("Ambientes cargados: " . count($ambientes));
} catch (Exception $e) {
    // Si hay error, continuamos sin datos
    error_log("Error cargando ambientes: " . $e->getMessage());
}

// Debug: Descomentar para ver los datos en la página
// echo '<pre>Depósitos: '; print_r($depositos); echo '</pre>';
// echo '<pre>Ambientes: '; print_r($ambientes); echo '</pre>';
// exit;

?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <title>Conteo Ciego - Sistema SOL</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <!-- Select2 CSS - DESHABILITADO TEMPORALMENTE -->
    <!-- <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" /> -->
    <!-- <link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" /> -->
    <!-- Custom Styles -->
    <link rel="stylesheet" href="assets/css/styles.css">
    <style>
        /* Estilos para conteo ciego: todas las posiciones lucen iguales */
        .posicion-cell,
        .posicion-cell.libre,
        .posicion-cell.ocupado,
        .posicion-cell.picked {
            background: white !important;
            border: 2px solid #caf0f8 !important;
            color: #023047 !important;
            box-shadow: none !important;
        }

        .posicion-cell::after,
        .posicion-cell.libre::after,
        .posicion-cell.ocupado::after,
        .posicion-cell.picked::after {
            background: white !important;
        }

        .posicion-cell:hover,
        .posicion-cell.libre:hover,
        .posicion-cell.ocupado:hover,
        .posicion-cell.picked:hover {
            background: #f0f9ff !important;
            border-color: #219ebc !important;
            transform: scale(1.05);
        }
    </style>
</head>

<body>
    <!-- Header -->
    <div class="header">
        <div class="header-content">
            <h1><i class="bi bi-calculator-fill"></i> Conteo Ciego</h1>
            <div class="user-info">
                <span class="user-name"><i class="bi bi-person-circle"></i>
                    <?php echo htmlspecialchars($nombre); ?></span>
                <a href="?logout=1" class="btn-logout"><i class="bi bi-box-arrow-right"></i> Salir</a>
            </div>
        </div>
    </div>

    <!-- Contenido principal -->
    <div class="container">
        <!-- Tarjeta de contador -->
        <div class="card">
            <h2><i class="bi bi-bar-chart-fill"></i> Selecciona depósito y ambiente</h2>
            <form action="">
                <div class="row g-3">
                    <div class="col-md-4">
                        <div class="input-group mb-3">
                            <select id="deposito" name="deposito" class="form-select" required>
                                <option value="">-- Seleccione depósito --</option>
                                <?php
                                if (count($depositos) > 0) {
                                    foreach ($depositos as $deposito): ?>
                                        <option value="<?php echo htmlspecialchars($deposito['id']); ?>">
                                            <?php echo htmlspecialchars(trim($deposito['nombre'])); ?>
                                        </option>
                                    <?php endforeach;
                                } else {
                                    echo '<option value="" disabled>No hay depósitos disponibles</option>';
                                }
                                ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="input-group mb-3">
                            <select id="rack" name="rack" class="form-select" disabled required>
                                <option value="">-- Seleccione rack --</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="input-group mb-3">
                            <select id="ambiente" name="ambiente" class="form-select">
                                <option value="">-- Todos los ambientes --</option>
                                <?php
                                if (count($ambientes) > 0) {
                                    foreach ($ambientes as $ambiente): ?>
                                        <option value="<?php echo htmlspecialchars($ambiente['id']); ?>">
                                            <?php echo htmlspecialchars(trim($ambiente['nombre'])); ?>
                                        </option>
                                    <?php endforeach;
                                } else {
                                    echo '<option value="" disabled>No hay ambientes disponibles</option>';
                                }
                                ?>
                            </select>
                        </div>
                    </div>
                </div>
            </form>
        </div>

        <!-- Tarjeta de Layout del Rack -->
        <div class="card" id="layout-card" style="display: none;">
            <h2><i class="bi bi-grid-3x3-gap"></i> Layout del Rack</h2>
            <div id="rack-info" class="alert alert-info">
                <i class="bi bi-info-circle"></i> <strong>Selecciona un rack</strong> para ver su layout
            </div>
            <div id="posiciones-container">
                <!-- Aquí se renderizará el layout visual -->
            </div>
            <div class="alert alert-warning mt-3">
                <i class="bi bi-eye-slash-fill"></i> <strong>Modo Conteo Ciego:</strong>
                Todas las posiciones se muestran sin indicadores de estado para realizar un conteo imparcial.
            </div>
        </div>

    </div>

    <!-- Modal para información de posición -->
    <div class="modal fade" id="posicionModal" tabindex="-1" aria-labelledby="posicionModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="posicionModalLabel">Detalle de posición</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <form id="posicion-form" autocomplete="off">
                        <input type="hidden" data-posicion-field="id" name="posicion_id" value="">
                        <input type="hidden" data-posicion-field="code-hidden" name="code" value="">
                        <div class="mb-3">
                            <label class="form-label mb-1" for="posicion-code">Código de la posición</label>
                            <p class="form-control-plaintext fw-semibold mb-0" id="posicion-code"
                                data-posicion-field="code">--</p>
                        </div>
                        <div class="mb-3">
                            <label for="posicion-sku" class="form-label">SKU</label>
                            <input type="text" class="form-control" id="posicion-sku" name="sku"
                                placeholder="Ej: ABC123" required>
                        </div>
                        <div class="mb-3">
                            <label for="posicion-lote" class="form-label">Lote</label>
                            <input type="text" class="form-control" id="posicion-lote" name="lote"
                                placeholder="Número de lote" required>
                        </div>
                        <div class="mb-3">
                            <label for="posicion-vencimiento" class="form-label">Vencimiento</label>
                            <input type="date" class="form-control" id="posicion-vencimiento" name="vencimiento"
                                required>
                        </div>
                        <div class="mb-3">
                            <label for="posicion-pallet" class="form-label">Pallet (cantidad)</label>
                            <input type="number" min="0" step="1" class="form-control" id="posicion-pallet"
                                name="pallet_cantidad" value="0" required>
                        </div>
                        <div class="mb-3">
                            <label for="posicion-cajas" class="form-label">Cajas sueltas (UV cantidad)</label>
                            <input type="number" min="0" step="1" class="form-control" id="posicion-cajas"
                                name="cajas_uv" value="0" required>
                        </div>
                        <div class="mb-3">
                            <label for="posicion-unidades" class="form-label">Unidades sueltas (UC cantidad)</label>
                            <input type="number" min="0" step="1" class="form-control" id="posicion-unidades"
                                name="unidades_uc" value="0" required>
                        </div>
                        <div class="mb-3">
                            <label for="posicion-total" class="form-label">Total de unidades</label>
                            <input type="number" min="0" step="1" class="form-control" id="posicion-total"
                                name="total_unidades" value="0" required>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                    <button type="submit" form="posicion-form" class="btn btn-primary">Guardar</button>
                </div>
            </div>
        </div>
    </div>

    <!-- jQuery (required for Select2) -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Select2 JS - DESHABILITADO TEMPORALMENTE -->
    <!-- <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script> -->
    <!-- Select2 Initialization - DESHABILITADO TEMPORALMENTE -->
    <!-- <script src="assets/js/select2-init.js"></script> -->
    <!-- Rack Loader (carga dinámica de racks) -->
    <script src="assets/js/rack-loader.js"></script>
    <!-- Rack Visualizer (renderizado visual del layout) -->
    <script src="assets/js/rack-visualizer.js"></script>
    <!-- Custom JS -->
    <script src="assets/js/contador.js"></script>
    <script>
        // Inicialización simple sin Select2
        console.log('Sistema de Conteo inicializado (sin Select2)');

        // Agregar vibración haptic a los selects nativos (excepto rack que ya tiene su propio handler)
        document.querySelectorAll('select:not(#rack):not(#deposito)').forEach(select => {
            select.addEventListener('change', function () {
                if (navigator.vibrate) {
                    navigator.vibrate(10);
                }
            });
        });
        navigator.vibrate(10);
    </script>
</body>

</html>