<?php
require_once 'config/config.php';

// Si ya está logueado, redirigir a conteo.php
if (isset($_SESSION['user_id'])) {
    header('Location: conteo.php');
    exit();
}

$error = '';

// Procesar login
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    if (!empty($username) && !empty($password)) {
        try {
            $db = getDBConnection();

            // Buscar usuario (ajusta los nombres de campos según tu tabla)
            $stmt = $db->prepare("SELECT * FROM sys_users WHERE username = ? OR email = ? LIMIT 1");
            $stmt->execute([$username, $username]);
            $user = $stmt->fetch();

            if ($user) {
                // Verificar contraseña (ajusta según cómo guardes las contraseñas)
                // Aquí asumo que puede ser password hasheado o en texto plano
                $passwordMatch = false;

                if (password_verify($password, $user['pass_hash'])) {
                    $passwordMatch = true;
                }

                if ($passwordMatch) {
                    // Login exitoso
                    $_SESSION['user_id'] = $user['id'] ?? $user['user_id'];
                    $_SESSION['username'] = $user['username'] ?? $user['user_name'];
                    $_SESSION['nombre'] = $user['full_name'] ?? $username;

                    header('Location: conteo.php');
                    exit();
                } else {
                    $error = 'Contraseña incorrecta';
                }
            } else {
                $error = 'Usuario no encontrado';
            }
        } catch (Exception $e) {
            $error = 'Error de conexión: ' . $e->getMessage();
        }
    } else {
        $error = 'Por favor complete todos los campos';
    }
}
?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <title>Login - Sistema de Conteo SOL</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <!-- Custom Styles -->
    <link rel="stylesheet" href="assets/css/styles.css">
</head>

<body class="login-page">
    <div class="login-container">
        <div class="logo">
            <h1><i class="bi bi-calculator-fill"></i> SOL</h1>
            <p>Sistema de Conteo</p>
        </div>

        <?php if ($error): ?>
            <div class="error">
                <?php echo htmlspecialchars($error); ?>
            </div>
        <?php endif; ?>

        <form method="POST" action="">
            <div class="form-group">
                <label for="username"><i class="bi bi-person-fill"></i> Usuario o Email</label>
                <input type="text" id="username" name="username" required autofocus autocomplete="username">
            </div>

            <div class="form-group">
                <label for="password"><i class="bi bi-lock-fill"></i> Contraseña</label>
                <input type="password" id="password" name="password" required autocomplete="current-password">
            </div>

            <button type="submit" class="btn-login"><i class="bi bi-box-arrow-in-right"></i> Iniciar Sesión</button>
        </form>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>