<?php
// Script para verificar la estructura de la tabla wh_posicion
require_once '../config/config.php';

try {
    $db = getDBConnection();

    echo "<h2>Estructura de la tabla wh_posicion:</h2>";
    echo "<pre>";
    $stmt = $db->query("DESCRIBE wh_posicion");
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        echo $row['Field'] . " (" . $row['Type'] . ") " .
            ($row['Null'] == 'YES' ? 'NULL' : 'NOT NULL') .
            ($row['Key'] == 'PRI' ? ' PRIMARY KEY' : '') . "\n";
    }
    echo "</pre>";

    echo "<h2>Datos de ejemplo:</h2>";
    echo "<pre>";
    $stmt = $db->query("SELECT * FROM wh_posicion LIMIT 10");
    $posiciones = $stmt->fetchAll(PDO::FETCH_ASSOC);
    print_r($posiciones);
    echo "</pre>";

    echo "<h2>Total de posiciones:</h2>";
    $stmt = $db->query("SELECT COUNT(*) as total FROM wh_posicion");
    $total = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "<p>Total: " . $total['total'] . " posiciones</p>";

    echo "<h2>Racks únicos por depósito:</h2>";
    echo "<pre>";
    $stmt = $db->query("
        SELECT 
            p.deposito_id,
            d.nombre as deposito_nombre,
            p.rack,
            COUNT(*) as total_posiciones
        FROM wh_posicion p
        LEFT JOIN wh_deposito d ON p.deposito_id = d.id
        GROUP BY p.deposito_id, p.rack
        ORDER BY p.deposito_id, p.rack
        LIMIT 20
    ");
    $racks_por_deposito = $stmt->fetchAll(PDO::FETCH_ASSOC);
    print_r($racks_por_deposito);
    echo "</pre>";

} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
