<?php
/**
 * Script para verificar la estructura de la tabla sys_users
 */

require_once '../config/config.php';

try {
    $db = getDBConnection();

    echo "<h2>Estructura de la tabla sys_users:</h2>";

    // Obtener estructura de la tabla
    $stmt = $db->query("DESCRIBE sys_users");
    $columns = $stmt->fetchAll();

    echo "<table border='1' cellpadding='5' cellspacing='0'>";
    echo "<tr><th>Campo</th><th>Tipo</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
    foreach ($columns as $column) {
        echo "<tr>";
        echo "<td>" . htmlspecialchars($column['Field']) . "</td>";
        echo "<td>" . htmlspecialchars($column['Type']) . "</td>";
        echo "<td>" . htmlspecialchars($column['Null']) . "</td>";
        echo "<td>" . htmlspecialchars($column['Key']) . "</td>";
        echo "<td>" . htmlspecialchars($column['Default']) . "</td>";
        echo "<td>" . htmlspecialchars($column['Extra']) . "</td>";
        echo "</tr>";
    }
    echo "</table>";

    // Contar usuarios
    $count = $db->query("SELECT COUNT(*) FROM sys_users")->fetchColumn();
    echo "<p><strong>Total de usuarios:</strong> " . $count . "</p>";

} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
?>