<?php
/**
 * Script para verificar las tablas wh_deposito y wh_ambiente
 */

require_once '../config/config.php';

?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verificar Tablas de Almacén</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            padding: 20px;
            background: #f5f5f5;
        }

        .container {
            max-width: 1200px;
        }

        .card {
            margin-bottom: 20px;
        }
    </style>
</head>

<body>
    <div class="container">
        <h1 class="mb-4"><i class="bi bi-database"></i> Verificación de Tablas de Almacén</h1>

        <?php
        try {
            $db = getDBConnection();

            // Verificar tabla wh_deposito
            echo '<div class="card">';
            echo '<div class="card-header bg-primary text-white"><h2 class="h5 mb-0">Tabla: wh_deposito</h2></div>';
            echo '<div class="card-body">';

            try {
                $stmt = $db->query("DESCRIBE wh_deposito");
                $columns = $stmt->fetchAll();

                echo '<h6>Estructura:</h6>';
                echo '<table class="table table-sm table-bordered">';
                echo '<tr><th>Campo</th><th>Tipo</th><th>Null</th><th>Key</th><th>Default</th></tr>';
                foreach ($columns as $column) {
                    echo '<tr>';
                    echo '<td>' . htmlspecialchars($column['Field']) . '</td>';
                    echo '<td>' . htmlspecialchars($column['Type']) . '</td>';
                    echo '<td>' . htmlspecialchars($column['Null']) . '</td>';
                    echo '<td>' . htmlspecialchars($column['Key']) . '</td>';
                    echo '<td>' . htmlspecialchars($column['Default'] ?? 'NULL') . '</td>';
                    echo '</tr>';
                }
                echo '</table>';

                // Mostrar datos
                $stmt = $db->query("SELECT * FROM wh_deposito ORDER BY nombre");
                $depositos = $stmt->fetchAll();

                echo '<h6 class="mt-3">Datos (' . count($depositos) . ' registros):</h6>';
                if (count($depositos) > 0) {
                    echo '<table class="table table-sm table-striped">';
                    echo '<tr><th>ID</th><th>Nombre</th></tr>';
                    foreach ($depositos as $dep) {
                        echo '<tr>';
                        echo '<td>' . htmlspecialchars($dep['id']) . '</td>';
                        echo '<td>' . htmlspecialchars($dep['nombre']) . '</td>';
                        echo '</tr>';
                    }
                    echo '</table>';
                } else {
                    echo '<div class="alert alert-warning">No hay depósitos registrados</div>';
                }

            } catch (Exception $e) {
                echo '<div class="alert alert-danger">Error: ' . htmlspecialchars($e->getMessage()) . '</div>';
            }

            echo '</div></div>';

            // Verificar tabla wh_ambiente
            echo '<div class="card">';
            echo '<div class="card-header bg-success text-white"><h2 class="h5 mb-0">Tabla: wh_ambiente</h2></div>';
            echo '<div class="card-body">';

            try {
                $stmt = $db->query("DESCRIBE wh_ambiente");
                $columns = $stmt->fetchAll();

                echo '<h6>Estructura:</h6>';
                echo '<table class="table table-sm table-bordered">';
                echo '<tr><th>Campo</th><th>Tipo</th><th>Null</th><th>Key</th><th>Default</th></tr>';
                foreach ($columns as $column) {
                    echo '<tr>';
                    echo '<td>' . htmlspecialchars($column['Field']) . '</td>';
                    echo '<td>' . htmlspecialchars($column['Type']) . '</td>';
                    echo '<td>' . htmlspecialchars($column['Null']) . '</td>';
                    echo '<td>' . htmlspecialchars($column['Key']) . '</td>';
                    echo '<td>' . htmlspecialchars($column['Default'] ?? 'NULL') . '</td>';
                    echo '</tr>';
                }
                echo '</table>';

                // Mostrar datos
                $stmt = $db->query("SELECT * FROM wh_ambiente ORDER BY nombre");
                $ambientes = $stmt->fetchAll();

                echo '<h6 class="mt-3">Datos (' . count($ambientes) . ' registros):</h6>';
                if (count($ambientes) > 0) {
                    echo '<table class="table table-sm table-striped">';
                    echo '<tr><th>ID</th><th>Nombre</th></tr>';
                    foreach ($ambientes as $amb) {
                        echo '<tr>';
                        echo '<td>' . htmlspecialchars($amb['id']) . '</td>';
                        echo '<td>' . htmlspecialchars($amb['nombre']) . '</td>';
                        echo '</tr>';
                    }
                    echo '</table>';
                } else {
                    echo '<div class="alert alert-warning">No hay ambientes registrados</div>';
                }

            } catch (Exception $e) {
                echo '<div class="alert alert-danger">Error: ' . htmlspecialchars($e->getMessage()) . '</div>';
            }

            echo '</div></div>';

        } catch (Exception $e) {
            echo '<div class="alert alert-danger">Error de conexión: ' . htmlspecialchars($e->getMessage()) . '</div>';
        }
        ?>

        <div class="mt-3">
            <a href="../conteo.php" class="btn btn-primary">← Volver al Sistema de Conteo</a>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>