<?php
require_once '../config/config.php';

header('Content-Type: application/json; charset=utf-8');

try {
    $db = getDBConnection();

    $response = [
        'success' => true,
        'depositos' => [],
        'ambientes' => [],
        'errors' => []
    ];

    // Cargar depósitos
    try {
        $stmt = $db->query("SELECT * FROM wh_deposito ORDER BY nombre");
        $response['depositos'] = $stmt->fetchAll();
        $response['depositos_count'] = count($response['depositos']);
    } catch (Exception $e) {
        $response['errors'][] = 'Error depósitos: ' . $e->getMessage();
    }

    // Cargar ambientes
    try {
        $stmt = $db->query("SELECT * FROM wh_ambiente ORDER BY nombre");
        $response['ambientes'] = $stmt->fetchAll();
        $response['ambientes_count'] = count($response['ambientes']);
    } catch (Exception $e) {
        $response['errors'][] = 'Error ambientes: ' . $e->getMessage();
    }

    echo json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ], JSON_PRETTY_PRINT);
}
?>