<?php
/**
 * Script para probar la conexión a la base de datos
 */

require_once '../config/config.php';

try {
    $db = getDBConnection();
    echo "✓ Conexión exitosa a la base de datos 'sol'<br>";

    // Obtener información del servidor
    $version = $db->query('SELECT VERSION()')->fetchColumn();
    echo "✓ Versión de MySQL: " . $version . "<br>";

    // Listar tablas disponibles
    $stmt = $db->query("SHOW TABLES");
    $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);

    echo "<br><strong>Tablas disponibles en la base de datos:</strong><br>";
    if (count($tables) > 0) {
        echo "<ul>";
        foreach ($tables as $table) {
            echo "<li>" . htmlspecialchars($table) . "</li>";
        }
        echo "</ul>";
    } else {
        echo "<em>No hay tablas en la base de datos</em><br>";
    }

} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage();
}
?>