<?php
declare(strict_types=1);
/**
 * SOL - Sistema de Operaciones Logísticas
 * Documento: public/docs/sys.php
 *
 * Propósito:
 * - Documentar el diseño actual de las tablas del subsistema "Sistema" (auth, roles y permisos).
 * - Resumir columnas, claves e índices, relaciones.
 * - Proponer mejoras justificadas SIN aplicarlas aún.
 *
 * Cómo se generó:
 * - Paso 1 del chat "Diseño general del proyecto BASE DE DATOS".
 * - Archivo único para inspección por navegador.
 *
 * Notas:
 * - Fuente de verdad: dump SQL provisto (sol (1).sql).
 * - No realiza consultas a BD; es estático para revisión de arquitectura.
 */
?><!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8"/>
  <title>SOL · Documentación de Tablas del Sistema (sys_*)</title>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <style>
    :root{--bg:#0b0b0d;--fg:#e8e8ea;--muted:#a7a7ad;--card:#131317;--accent:#4da3ff;--ok:#53d769;--warn:#ffd666;--bad:#ff6b6b}
    *{box-sizing:border-box} body{margin:0;font:14px/1.5 system-ui,Segoe UI,Roboto,Helvetica,Arial,sans-serif;background:var(--bg);color:var(--fg)}
    .wrap{max-width:1100px;margin:32px auto;padding:0 16px}
    h1,h2,h3{margin:0 0 10px} h1{font-size:28px} h2{font-size:22px;margin-top:24px}
    .card{background:var(--card);border:1px solid #222; border-radius:14px;padding:18px;margin:14px 0;box-shadow:0 1px 0 #0003}
    .grid{display:grid;gap:14px}
    .grid.cols-2{grid-template-columns:repeat(2,minmax(0,1fr))}
    .kbd{font:12px/1.2 ui-monospace,SFMono-Regular,Menlo,Consolas,monospace;background:#1a1a20;border:1px solid #2a2a31;border-radius:8px;padding:2px 6px}
    table{width:100%;border-collapse:collapse;border-spacing:0;margin:8px 0}
    th,td{padding:8px 10px;border-bottom:1px solid #23232a;vertical-align:top}
    th{background:#18181d;text-align:left}
    code,pre{font:12px ui-monospace,SFMono-Regular,Menlo,Consolas,monospace;background:#15151a;color:#dcdce0}
    pre{padding:10px;border:1px solid #222;border-radius:10px;overflow:auto}
    .pill{display:inline-block;border:1px solid #2a2a31;border-radius:999px;padding:2px 10px;background:#14141a;color:var(--muted);font-size:12px}
    .ok{color:var(--ok)} .warn{color:var(--warn)} .bad{color:var(--bad)}
    a{color:var(--accent);text-decoration:none} a:hover{text-decoration:underline}
    .muted{color:var(--muted)} .small{font-size:12px}
  </style>
</head>
<body>
  <div class="wrap">
    <h1>Documentación · Subsistema de Sistema (<span class="kbd">sys_*</span>)</h1>
    <p class="muted">Autenticación, control de acceso por roles, menú y alcance por operativa. Fuente: <span class="kbd">sol (1).sql</span>.</p>

    <div class="card">
      <h2>Resumen ejecutivo</h2>
      <ul>
        <li><b>Tablas incluidas:</b> <span class="kbd">sys_users</span>, <span class="kbd">sys_role</span>, <span class="kbd">sys_role_rights</span>, <span class="kbd">sys_menu</span>, <span class="kbd">sys_operativas</span>.</li>
        <li><b>Modelo:</b> Acceso por <b>rol</b> con permisos por <b>menú</b> (can_view/create/edit/delete). Usuarios asignados a una <b>operativa</b> (multicliente/tenant ligero).</li>
        <li><b>Estado general:</b> funcional, índices básicos presentes, FKs definidos (salvo jerarquía en menú). Cohesivo para MVP.</li>
      </ul>
    </div>

    <div class="grid cols-2">
      <div class="card">
        <h2>sys_users</h2>
        <p>Usuarios del sistema, con vínculo a rol y operativa.</p>
        <table>
          <tr><th>Columna</th><th>Tipo / Detalle</th></tr>
          <tr><td>id</td><td>INT, PK, AI</td></tr>
          <tr><td>username</td><td>VARCHAR(60) <span class="pill">NOT NULL</span></td></tr>
          <tr><td>full_name</td><td>VARCHAR(150)</td></tr>
          <tr><td>email</td><td>VARCHAR(150)</td></tr>
          <tr><td>pass_hash</td><td>VARCHAR(255) (bcrypt)</td></tr>
          <tr><td>role_code</td><td>INT <span class="pill">FK → sys_role(id)</span> (RESTRICT/RESTRICT)</td></tr>
          <tr><td>operativa_id</td><td>INT <span class="pill">FK → sys_operativas(id)</span></td></tr>
          <tr><td>created_at / updated_at / deleted_at</td><td>timestamp (soft delete por <span class="kbd">deleted_at</span>)</td></tr>
        </table>
        <p><b>Índices/FK:</b> PK(id); FK(role_code), FK(operativa_id). <span class="warn">No hay UNIQUE(username/email).</span></p>
      </div>

      <div class="card">
        <h2>sys_role</h2>
        <p>Catálogo de roles.</p>
        <table>
          <tr><th>Columna</th><th>Tipo / Detalle</th></tr>
          <tr><td>id</td><td>INT, PK, AI</td></tr>
          <tr><td>name</td><td>VARCHAR(50)</td></tr>
          <tr><td>description</td><td>VARCHAR(255)</td></tr>
          <tr><td>activo</td><td>TINYINT(1) default 1</td></tr>
          <tr><td>created_at / updated_at</td><td>datetime</td></tr>
        </table>
        <p><b>Índices:</b> PK(id). <span class="warn">No hay UNIQUE(name).</span></p>
      </div>

      <div class="card">
        <h2>sys_role_rights</h2>
        <p>Matriz de permisos por (rol, menú).</p>
        <table>
          <tr><th>Columna</th><th>Tipo / Detalle</th></tr>
          <tr><td>id</td><td>INT, PK, AI</td></tr>
          <tr><td>role_id</td><td>INT <span class="pill">FK → sys_role(id)</span></td></tr>
          <tr><td>menu_id</td><td>INT <span class="pill">FK → sys_menu(id)</span></td></tr>
          <tr><td>can_view / can_create / can_edit / can_delete</td><td>TINYINT(1) defaults (1/0/0/0)</td></tr>
          <tr><td>created_at / updated_at</td><td>datetime</td></tr>
        </table>
        <p><b>Índices:</b> PK(id); índices combinados para consultas (<span class="kbd">idx_rr_role_view</span>, <span class="kbd">idx_rr_menu</span>). <span class="warn">Falta UNIQUE(role_id,menu_id).</span></p>
      </div>

      <div class="card">
        <h2>sys_menu</h2>
        <p>Árbol de navegación del sistema.</p>
        <table>
          <tr><th>Columna</th><th>Tipo / Detalle</th></tr>
          <tr><td>id</td><td>INT, PK</td></tr>
          <tr><td>parent_id</td><td>INT (jerarquía). <span class="warn">Sin FK a sys_menu(id).</span></td></tr>
          <tr><td>name</td><td>VARCHAR(100)</td></tr>
          <tr><td>icon</td><td>VARCHAR(50)</td></tr>
          <tr><td>url</td><td>VARCHAR(255) (nullable para grupos)</td></tr>
          <tr><td>orden</td><td>INT default 0</td></tr>
          <tr><td>activo</td><td>TINYINT(1) default 1</td></tr>
          <tr><td>created_at / updated_at</td><td>datetime</td></tr>
        </table>
        <p><b>Índices:</b> PK(id); <span class="kbd">idx_sys_menu_parent(parent_id)</span>, <span class="kbd">idx_sys_menu_activo(activo,parent_id,orden)</span>.</p>
      </div>

      <div class="card">
        <h2>sys_operativas</h2>
        <p>Ámbito/tenant ligero para segmentación por cliente/operativa.</p>
        <table>
          <tr><th>Columna</th><th>Tipo / Detalle</th></tr>
          <tr><td>id</td><td>INT, PK, AI</td></tr>
          <tr><td>nombre</td><td>VARCHAR(150) (nullable)</td></tr>
          <tr><td>created_at / updated_at / deleted_at</td><td>timestamp</td></tr>
        </table>
        <p><b>Índices:</b> PK(id). <span class="warn">No hay UNIQUE(nombre).</span></p>
      </div>
    </div>

    <div class="card">
      <h2>Consistencia técnica observada</h2>
      <ul>
        <li><b>Collation/charset mixtos:</b> <span class="kbd">utf8mb4_0900_ai_ci</span> (en <span class="kbd">sys_menu</span>, <span class="kbd">sys_role</span>, <span class="kbd">sys_role_rights</span>) vs <span class="kbd">utf8mb4_unicode_ci</span> (en <span class="kbd">sys_users</span>, <span class="kbd">sys_operativas</span>). <span class="warn">Inconsistente</span>.</li>
        <li><b>Tipos de tiempo mixtos:</b> <span class="kbd">datetime</span> y <span class="kbd">timestamp</span> se usan indistintamente para audit. <span class="warn">Inconsistente</span>.</li>
        <li><b>Faltan UNIQUE claves naturales</b> en <span class="kbd">sys_users.username/email</span>, <span class="kbd">sys_role.name</span>, <span class="kbd">sys_operativas.nombre</span>.</li>
        <li><b>Menú jerárquico</b> sin FK <span class="kbd">parent_id → sys_menu(id)</span> (puede permitir huérfanos).</li>
        <li><b>Permisos duplicados</b>: sin UNIQUE(<span class="kbd">role_id,menu_id</span>) se pueden duplicar filas en <span class="kbd">sys_role_rights</span>.</li>
      </ul>
    </div>

    <div class="card">
      <h2>Propuesta de mejora (no aplicada aún)</h2>
      <ol>
        <li><b>Unificar collation/charset</b> a <span class="kbd">utf8mb4_unicode_ci</span> (o <span class="kbd">utf8mb4_0900_ai_ci</span> si MySQL ≥ 8.0.13) en todas las tablas <span class="kbd">sys_*</span>. <span class="small muted">Evita problemas en JOIN/índices y ordenamientos.</span></li>
        <li><b>Estandarizar auditoría</b> a <span class="kbd">datetime</span> (o a <span class="kbd">timestamp</span> en todo el sistema) con <span class="kbd">DEFAULT CURRENT_TIMESTAMP</span> y <span class="kbd">ON UPDATE CURRENT_TIMESTAMP</span> para <span class="kbd">updated_at</span>.</li>
        <li><b>Claves únicas</b>:
          <ul>
            <li><span class="kbd">sys_users(username)</span> UNIQUE y <span class="kbd">sys_users(email)</span> UNIQUE (si se requiere login por correo o integridad de contacto).</li>
            <li><span class="kbd">sys_role(name)</span> UNIQUE.</li>
            <li><span class="kbd">sys_operativas(nombre)</span> UNIQUE (si el nombre es identificador operacional).</li>
            <li><span class="kbd">sys_role_rights(role_id,menu_id)</span> UNIQUE para evitar duplicados de permisos.</li>
          </ul>
        </li>
        <li><b>Integridad del árbol de menú</b>: agregar FK <span class="kbd">sys_menu.parent_id → sys_menu.id</span> con <span class="kbd">ON DELETE SET NULL</span> para prevenir huérfanos y permitir borrar nodos hoja sin romper hijos.</li>
        <li><b>Índices de uso frecuente</b>:
          <ul>
            <li><span class="kbd">sys_users(username)</span> INDEX (si no se marca UNIQUE), y opcionalmente <span class="kbd">sys_users(email)</span>.</li>
            <li><span class="kbd">sys_menu(orden)</span> combinado con <span class="kbd">(parent_id, activo)</span> ya existe parcialmente — revisar planes de consulta.</li>
          </ul>
        </li>
        <li><b>Campos operativos útiles (futuro)</b>:
          <ul>
            <li><span class="kbd">sys_users.last_login_at</span>, <span class="kbd">last_login_ip</span>, <span class="kbd">must_change_password</span>.</li>
            <li>Auditoría opcional: <span class="kbd">created_by</span>, <span class="kbd">updated_by</span> (FK a <span class="kbd">sys_users</span>).</li>
          </ul>
        </li>
      </ol>
      <p class="muted small">Estas mejoras no cambian el modelo conceptual (roles → permisos por menú), solo endurecen integridad y consistencia.</p>
    </div>

    <div class="card">
      <h2>Impacto y justificación</h2>
      <ul>
        <li><b>Unicidad de credenciales</b> (<span class="kbd">username/email</span>): elimina ambigüedad en login y notificaciones.</li>
        <li><b>Integridad referencial en menú</b>: bloquea estados inválidos (nodos huérfanos) y simplifica ordenamiento/árbol.</li>
        <li><b>Permisos sin duplicidad</b>: la UNIQUE(<span class="kbd">role_id,menu_id</span>) garantiza una sola fila por par, simplificando consultas y UI.</li>
        <li><b>Consistencia en tipos/charset</b>: previene errores sutiles en joins/ordenamientos/exportaciones.</li>
        <li><b>Trazabilidad de acceso</b> (last_login_*): útil para seguridad, auditoría y soporte.</li>
      </ul>
    </div>

    <div class="card">
      <h2>Checklist para un próximo paso (si lo apruebas)</h2>
      <ol>
        <li>Generar <b>migración</b> SQL de endurecimiento: collations, UNIQUEs, FK del árbol de menú, índices.</li>
        <li>Alinear <b>DAO/queries</b> de login y carga de menú con nuevas restricciones.</li>
        <li>Agregar columnas opcionales de auditoría de login (si se desea).</li>
      </ol>
      <p class="muted small">Este documento no aplica cambios; solo sirve para acordar el plan.</p>
    </div>

    <p class="small muted">© <?= htmlspecialchars(getenv('APP_NAME') ?: 'SOL') ?> — Documento generado para revisión interna.</p>
  </div>
</body>
</html>