<?php
session_start();
include_once '../libreria/ezSql/ez_sql_core.php';
include_once '../libreria/ezSql/ez_sql_pdo.php';
include_once '../libreria/ezSql/conect.php';

$depositoSeleccionado = $_POST['deposito'] ?? '';
$fechaConteo1 = $_POST['fechaConteo1'] ?? date('Y-m-d');
$fechaConteo2 = $_POST['fechaConteo2'] ?? date('Y-m-d');

// Traer layout
$depositoLayout = [];
if ($depositoSeleccionado) {
    $query = "SELECT id, deposito, rack, columna, nivel, fondo
        FROM ope_layout
        WHERE deposito = '$depositoSeleccionado'
        ORDER BY rack, columna, nivel, fondo";
    $resultados = $db->get_results($query);
    foreach ($resultados as $fila) {
        $depositoLayout[$fila->deposito][$fila->rack][$fila->columna][$fila->nivel][] = [
            'id' => $fila->id, // El ID real
            'fondo' => $fila->fondo,
            // Otros datos si necesitas
        ];
    }
}

// Traer posiciones por fecha
$resultado = $db->get_results("SELECT cc.posicion_id, pp.color_web, DATE(cc.created_at) as fecha_conteo
    FROM ctrl_conteo cc 
    LEFT JOIN para_productos pp ON pp.id = cc.producto 
    WHERE DATE(cc.created_at) BETWEEN '$fechaConteo1' AND '$fechaConteo2'
    ORDER BY fecha_conteo ASC, posicion_id");

$posicionesPorFecha = [];
$coloresPorFecha = [];
if ($resultado) {
    foreach ($resultado as $row) {
        $fecha = $row->fecha_conteo;
        $posicionesPorFecha[$fecha][] = $row->posicion_id;
        $coloresPorFecha[$fecha][$row->posicion_id] = $row->color_web;
    }
}
$fechasDisponibles = array_keys($posicionesPorFecha);


// Si no hay datos de conteo, igual agrega la(s) fecha(s) seleccionada(s)
if (empty($fechasDisponibles)) {
    // Si el rango es solo un día
    if ($fechaConteo1 === $fechaConteo2) {
        $fechasDisponibles = [$fechaConteo1];
    } else {
        // Si es un rango, genera todas las fechas entre inicio y fin
        $fechasDisponibles = [];
        $start = strtotime($fechaConteo1);
        $end = strtotime($fechaConteo2);
        for ($i = $start; $i <= $end; $i += 86400) {
            $fechasDisponibles[] = date('Y-m-d', $i);
        }
    }
    // Asegura que los arrays están vacíos pero existen para cada fecha
    foreach ($fechasDisponibles as $fecha) {
        $posicionesPorFecha[$fecha] = [];
        $coloresPorFecha[$fecha] = [];
    }
}


echo json_encode([
    'depositoLayout' => $depositoLayout,
    'posicionesPorFecha' => $posicionesPorFecha,
    'coloresPorFecha' => $coloresPorFecha,
    'fechasDisponibles' => $fechasDisponibles
]);
