<?php
session_start();
include_once '../libreria/ezSql/ez_sql_core.php';
include_once '../libreria/ezSql/ez_sql_pdo.php';
include_once '../libreria/ezSql/conect.php';

$depositoSeleccionado = $_POST['deposito'] ?? '';
$fecha = $_POST['fecha'] ?? date('Y-m-d');

// 1. Total de posiciones
$sqlTotal = "SELECT COUNT(*) as total FROM ope_layout WHERE deposito = '$depositoSeleccionado'";
$totalPosiciones = $db->get_var($sqlTotal);

// 2. Ocupadas (ese día)
$sqlOcupadas = "
  SELECT COUNT(DISTINCT posicion_id) as ocupadas
  FROM ctrl_conteo cc
  JOIN ope_layout ol ON cc.posicion_id = ol.id
  WHERE ol.deposito = '$depositoSeleccionado'
    AND DATE(cc.created_at) = '$fecha'
";
$posicionesOcupadas = $db->get_var($sqlOcupadas);

// 3. Vacías
$posicionesVacias = $totalPosiciones - $posicionesOcupadas;

// 4. % ocupadas y vacías
$porcentajeOcupadas = $totalPosiciones > 0 ? round(100 * $posicionesOcupadas / $totalPosiciones, 2) : 0;
$porcentajeVacias = $totalPosiciones > 0 ? round(100 * $posicionesVacias / $totalPosiciones, 2) : 0;

// 5. Detalle por código
$sqlDetalle = "
  SELECT pp.cod, COUNT(*) as cantidad
  FROM ctrl_conteo cc
  JOIN para_productos pp ON cc.producto = pp.id
  JOIN ope_layout ol ON cc.posicion_id = ol.id
  WHERE ol.deposito = '$depositoSeleccionado'
    AND DATE(cc.created_at) = '$fecha'
  GROUP BY pp.cod
  ORDER BY cantidad DESC
";
$detalleCodigos = $db->get_results($sqlDetalle);

echo json_encode([
    "total" => $totalPosiciones,
    "ocupadas" => $posicionesOcupadas,
    "vacias" => $posicionesVacias,
    "porcentaje_ocupadas" => $porcentajeOcupadas,
    "porcentaje_vacias" => $porcentajeVacias,
    "detalle" => $detalleCodigos
]);
exit;
