<?php
declare(strict_types=1);

/* =========================
   CONFIG APP (sin .env)
   ========================= */
const APP_NAME       = 'SOL';
const APP_CLIENTE    = 'SOL - Sistema de Operaciones Logísticas';
const APP_ENV        = 'local';
const APP_DEBUG      = true;
const APP_TIMEZONE   = 'America/Asuncion';

const APP_BASE_PATH  = '';
const BASE_URL       = 'http://sol.test/layoutinteractivo/';

const DB_HOST        = 'localhost';  // se probará también 127.0.0.1
const DB_NAME        = 'sol';
const DB_USER        = 'arasa';
const DB_PASS        = 'Chocla1508#@';   // <-- la que QUERÉS usar
const DB_CHARSET     = 'utf8mb4';
const DB_COLLATION   = 'utf8mb4_0900_ai_ci';
const DB_PORT        = 3306;

date_default_timezone_set(APP_TIMEZONE);

/**
 * Conecta a MySQL usando PDO, probando 2 hosts y (temporalmente) 2 contraseñas
 * para descartar el clásico # vs $.
 */
function pdo_connect(): PDO {
    $hosts = [DB_HOST, '127.0.0.1'];
    $passes = [DB_PASS, 'Chocla1508#@']; // TEMP: probá ambas; luego deja solo la correcta
    $lastErr = null;

    foreach ($hosts as $h) {
        foreach ($passes as $p) {
            $dsn = "mysql:host={$h};port=".DB_PORT.";dbname=".DB_NAME.";charset=".DB_CHARSET;
            try {
                $pdo = new PDO($dsn, DB_USER, $p, [
                    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES   => false,
                ]);
                $pdo->exec("SET NAMES '".DB_CHARSET."' COLLATE '".DB_COLLATION."'");
                return $pdo;
            } catch (PDOException $e) {
                $lastErr = $e;
                // sigue intentando con siguiente combinación
            }
        }
    }

    if (APP_DEBUG) {
        header('Content-Type: application/json; charset=UTF-8');
        echo json_encode([
            'ok' => false,
            'error' => 'No se pudo conectar a la base de datos',
            'detail' => $lastErr ? $lastErr->getMessage() : 'Error desconocido'
        ], JSON_UNESCAPED_UNICODE);
    }
    exit;
}

$pdo = pdo_connect();

/* ============ Wrapper opcional tipo ezSQL ============ */
class EzPdoCompat {
    private PDO $pdo;
    public function __construct(PDO $pdo) { $this->pdo = $pdo; }
    public function get_col(string $sql): array { $s=$this->pdo->query($sql); return $s->fetchAll(PDO::FETCH_COLUMN,0); }
    public function get_var(string $sql) { $s=$this->pdo->query($sql); $r=$s->fetch(PDO::FETCH_NUM); return $r!==false?$r[0]:null; }
    public function get_row(string $sql) { $s=$this->pdo->query($sql); $r=$s->fetch(PDO::FETCH_ASSOC); return $r!==false?(object)$r:null; }
    public function get_results(string $sql): array { $s=$this->pdo->query($sql); $rows=$s->fetchAll(PDO::FETCH_ASSOC); return array_map(fn($r)=>(object)$r,$rows); }
    public function query(string $sql): int { return $this->pdo->exec($sql); }
    public function prepare(string $sql): PDOStatement { return $this->pdo->prepare($sql); }
    public function pdo(): PDO { return $this->pdo; }
}
$db = new EzPdoCompat($pdo);
