<?php
session_start();

// Si el usuario NO está logueado, lo redirigimos al login
if (empty($_SESSION['usuario_id'])) {
    header('Location: index.php?error=Debe iniciar sesión');
    exit;
}

include_once '../libreria/ezSql/ez_sql_core.php';
include_once '../libreria/ezSql/ez_sql_pdo.php';
include_once '../libreria/ezSql/conect.php';

$depositoSeleccionado = $_POST['deposito'] ?? '';
$rackSeleccionado     = $_POST['rack'] ?? '';

$depositoLayout = [];

if ($depositoSeleccionado && $rackSeleccionado) {
    $depositoSeleccionado = addslashes($depositoSeleccionado);
    $rackSeleccionado     = addslashes($rackSeleccionado);

    $query = "SELECT id, deposito, rack, columna, nivel, fondo
              FROM ope_layout
              WHERE deposito = '$depositoSeleccionado'
                AND rack     = '$rackSeleccionado'
              ORDER BY columna, nivel, fondo";
    $resultados = $db->get_results($query);

    foreach ($resultados as $fila) {
        $depositoLayout[$fila->deposito][$fila->rack][$fila->columna][$fila->nivel][] = $fila->fondo;
    }
}

// Para el select de depósitos
$depositos = $db->get_results("SELECT DISTINCT deposito FROM ope_layout ORDER BY deposito");

// Traer posiciones contadas hoy (agrupadas)
$resultado = $db->get_results("
    SELECT cc.posicion_id,
           COUNT(cc.id) AS cantidad_pallets,
           GROUP_CONCAT(pp.color_web) AS colores,
           GROUP_CONCAT(pp.cod) AS codigos
    FROM ctrl_conteo cc
    LEFT JOIN para_productos pp ON pp.id = cc.producto
    WHERE DATE(cc.created_at) = CURDATE()
    GROUP BY cc.posicion_id
");

$posicionesContadas = [];
if ($resultado) {
    foreach ($resultado as $row) {
        $posicionesContadas[$row->posicion_id] = [
            'cantidad' => $row->cantidad_pallets,
            'colores'  => explode(',', $row->colores),
            'codigos'  => explode(',', $row->codigos)
        ];
    }
}

function degradadoLateral($baseColor)
{
    return "background: linear-gradient(135deg, $baseColor 50%, #fff 100%) !important;";
}
?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Conteo de depósitos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="layoutInteractivo.css" rel="stylesheet">
</head>

<body class="bg-dark">

    <div class="container py-4">
        <div class="card shadow-lg rounded-4 border-0 bg-white mb-4">
            <div class="card-header border-0 bg-primary text-white rounded-top-4 text-center py-4">
                <div class="row">
                    <div class="col-6">
                        <img src="img/logo.png" alt="BMSA" class="img-fluid" style="max-height: 20vh;">
                    </div>
                    <div class="col-6">
                        <h1 class="mb-0 fw-bold fs-2">
                            <?php echo $rackSeleccionado != ''
                                ? 'CONTEO de<br> DEPÓSITO: ' . $depositoSeleccionado . ' - RACK: ' . $rackSeleccionado
                                : 'SELECCIONAR PARA CONTAR'; ?>
                        </h1>
                    </div>
                </div>
            </div>
            <div class="card-body py-4">

                <?php
                $racks = [];
                if ($depositoSeleccionado) {
                    $query = "SELECT DISTINCT rack FROM ope_layout WHERE deposito = '$depositoSeleccionado' ORDER BY rack";
                    $racks = $db->get_col($query);
                }
                ?>
                <form id="formVerLayout" method="POST" class="row g-4 mb-4 px-2">
                    <div class="col-12">
                        <select name="deposito" id="deposito" class="form-select form-select-lg rounded-3" required>
                            <option value="">DEPÓSITO...</option>
                            <?php foreach ($depositos as $dep): ?>
                                <option value="<?= htmlspecialchars($dep->deposito) ?>" <?= $depositoSeleccionado === $dep->deposito ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($dep->deposito) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-12">
                        <select name="rack" id="rack" class="form-select form-select-lg rounded-3" required <?= !$depositoSeleccionado ? 'disabled' : '' ?>>
                            <option value="">RACK...</option>
                            <?php foreach ($racks as $rack): ?>
                                <option value="<?= htmlspecialchars($rack) ?>" <?= $rackSeleccionado === $rack ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($rack) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </form>

                <?php if ($depositoSeleccionado && $rackSeleccionado): ?>
                    <?php foreach ($depositoLayout as $nombreDeposito => $racks): ?>
                        <div class="mb-4">
                            <?php foreach ($racks as $nombreRack => $columnas): ?>
                                <div class="mb-3 ps-3">
                                    <div class="row">
                                        <?php foreach ($columnas as $nombreColumna => $niveles): ?>
                                            <div class="col-6 col-md-2 columna text-center">
                                                <?php foreach ($niveles as $nombreNivel => $fondos): ?>
                                                    <div class="nivel">
                                                        <div class="titulo-seccion mb-4">
                                                            <?= $nombreDeposito . ' - ' . $nombreRack . ' <br> ' . $nombreColumna . ' - ' . $nombreNivel ?>
                                                        </div>

                                                        <?php foreach ($fondos as $index => $color): ?>
                                                            <?php
                                                            $posicionId = $db->get_var("
                                                            SELECT id FROM ope_layout
                                                            WHERE deposito = '$nombreDeposito'
                                                              AND rack = '$nombreRack'
                                                              AND columna = '$nombreColumna'
                                                              AND nivel = '$nombreNivel'
                                                              AND fondo = '" . ($index + 1) . "'
                                                        ");

                                                            $cuboColor = '#fff';
                                                            $codigoProducto = '';
                                                            $numPallet = '';

                                                            if (isset($posicionesContadas[$posicionId])) {
                                                                $cantidadPallets = $posicionesContadas[$posicionId]['cantidad'];
                                                                if ($cantidadPallets == 1) {
                                                                    $cuboColor = '#' . $posicionesContadas[$posicionId]['colores'][0];
                                                                    $codigoProducto = $posicionesContadas[$posicionId]['codigos'][0];
                                                                    $numPallet = 1;
                                                                } elseif ($cantidadPallets > 1) {
                                                                    $cuboColor = 'multiple'; // marcador especial
                                                                    $codigoProducto = $cantidadPallets . ' pallets';
                                                                    $numPallet = $cantidadPallets;
                                                                }
                                                            }
                                                            ?>
                                                            <div class="fondo-cubo"
                                                                data-deposito="<?= $nombreDeposito ?>"
                                                                data-rack="<?= $nombreRack ?>"
                                                                data-columna="<?= $nombreColumna ?>"
                                                                data-nivel="<?= $nombreNivel ?>"
                                                                data-fondo="<?= $index + 1 ?>">
                                                                <div class="cubo-inner">
                                                                    <?php for ($face = 0; $face < 6; $face++): ?>
                                                                        <?php
                                                                        $faceClass = ['front', 'back', 'right', 'left', 'top', 'bottom'][$face];
                                                                        if ($cuboColor === 'multiple') {
                                                                            $faceStyle = "background: linear-gradient(135deg, yellow 50%, black 50%) !important;";
                                                                        } else {
                                                                            if ($faceClass === 'front') {
                                                                                $faceStyle = "background-color: $cuboColor !important;";
                                                                            } else {
                                                                                $faceStyle = degradadoLateral($cuboColor);
                                                                            }
                                                                        }
                                                                        ?>
                                                                        <div class="cara <?= $faceClass ?>" style="<?= $faceStyle ?>">
                                                                            <span id="caraTicket<?= $posicionId ?>" class="badge bg-secondary position-absolute top-0 end-0 m-1">
                                                                                <?php if ($faceClass === 'front' && $numPallet): ?>
                                                                                    <?= htmlspecialchars($index + 1) ?><br><br>
                                                                                    <?= htmlspecialchars($codigoProducto) ?>
                                                                                <?php else: ?>
                                                                                    <?= htmlspecialchars($index + 1) ?>
                                                                                <?php endif; ?>
                                                                            </span>
                                                                        </div>
                                                                    <?php endfor; ?>
                                                                </div>
                                                            </div>
                                                        <?php endforeach; ?>
                                                    </div>
                                                <?php endforeach; ?>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="container text-center text-muted">
                        <p>Seleccioná un depósito y un rack para ver el layout.</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Modal -->
        <div class="modal fade" id="modalFormulario" tabindex="-1" aria-labelledby="modalFormularioLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <form id="formCubo">
                        <input type="hidden" id="modoConteo" name="modo" value="picking">
                        <input type="hidden" id="bloqueIdActual" name="bloque_id_global" value="">

                        <div class="modal-header bg-secondary text-white d-flex align-items-center justify-content-between">
                            <!-- Botón agregar -->
                            <button type="button" id="btnAgregarPallet" class="btn btn-success btn-lg fw-bold">
                                <i class="fa fa-plus me-2"></i>
                            </button>

                            <!-- Título centrado -->
                            <h5 class="modal-title flex-grow-1 text-center mb-0" id="modalFormularioLabel">
                                Información de pallets
                            </h5>

                            <!-- Switch Normal / Pickeado -->
                            <div class="form-check form-switch text-white ms-3">
                                <input class="form-check-input" type="checkbox" id="switchTipoPallet" checked>
                                <label class="form-check-label" for="switchTipoPallet">Picking</label>
                            </div>

                            <!-- Botón cerrar -->
                            <button type="button" class="btn-close btn-close-white ms-2" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                        </div>

                        <div class="modal-body">
                            <input type="hidden" id="ubicacionDeposito" name="deposito">
                            <input type="hidden" id="ubicacionRack" name="rack">
                            <input type="hidden" id="ubicacionColumna" name="columna">
                            <input type="hidden" id="ubicacionNivel" name="nivel">
                            <input type="hidden" id="ubicacionFondo" name="fondo">

                            <!-- contenedor en grilla (3 columnas en lg) -->
                            <div id="palletsContainer" class="row g-3"></div>
                        </div>

                        <div class="modal-footer">
                            <button type="submit" class="btn btn-success">Guardar</button>
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="conteoInteractivo.js"></script>
</body>

</html>
