<?php
session_start();

$usuario = $_SESSION['usuario_id'];

// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

include_once '../libreria/ezSql/ez_sql_core.php';
include_once '../libreria/ezSql/ez_sql_pdo.php';
include_once '../libreria/ezSql/conect.php';

$depositoSeleccionado = $_GET['deposito'] ?? '';
$rackSeleccionado = $_GET['rack'] ?? '';

$depositoLayout = [];

if ($depositoSeleccionado && $rackSeleccionado) {
    $depositoSeleccionado = addslashes($depositoSeleccionado);
    $rackSeleccionado = addslashes($rackSeleccionado);

    $query = "SELECT id, deposito, rack, columna, nivel, fondo
        FROM ope_layout
        WHERE deposito = '$depositoSeleccionado'
          AND rack = '$rackSeleccionado'
        ORDER BY columna, nivel, fondo
    ";

    $resultados = $db->get_results($query);

    foreach ($resultados as $fila) {
        $depositoLayout[$fila->deposito][$fila->rack][$fila->columna][$fila->nivel][] = $fila->fondo;
    }
}

// Para el select de depósitos
$depositos = $db->get_results("SELECT DISTINCT deposito FROM ope_layout ORDER BY deposito");

// Traer todas las posiciones contadas hoy
$resultado = $db->get_results("SELECT cc.posicion_id, pp.color_web 
                               FROM ctrl_conteo cc 
                               LEFT JOIN para_productos pp ON pp.id = cc.producto 
                               WHERE DATE(cc.created_at) = CURDATE();
");
// $db->debug();
$posicionesContadas = [];
$posicionesColor = [];
if ($resultado) {
    foreach ($resultado as $row) {
        $posicionesContadas[] = $row->posicion_id;
        $posicionesColor[$row->posicion_id] = $row->color_web;
    }
}


?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Conteo de depósitos - <?= $usuario ?></title>

    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <link href="layoutInteractivo.css" rel="stylesheet">
</head>

<body class="bg-dark">

    <div class="container py-4">
        <div class="card shadow-lg rounded-4 border-0 bg-white mb-4">
            <div class="card-header border-0 bg-primary text-white rounded-top-4 text-center py-4">
                <div class="row">
                    <div class="col-6">
                        <img src="img/logo.png" alt="BMSA" class="img-fluid" style="max-height: 20vh;">
                    </div>
                    <div class="col-6">
                        <h1 class="mb-0 fw-bold fs-2"><?php echo $rackSeleccionado != '' ? 'CONTEO de<br> DEPÓSITO: ' . $depositoSeleccionado . ' - RACK: ' . $rackSeleccionado : 'SELECCIONAR PARA CONTAR'; ?></h1>
                    </div>
                </div>                
            </div>
            <div class="card-body py-4">


                <?php
                // ... Antes del HTML
                $racks = [];
                if ($depositoSeleccionado) {
                    $query = "SELECT DISTINCT rack FROM ope_layout WHERE deposito = '$depositoSeleccionado' ORDER BY rack";
                    $racks = $db->get_col($query);
                }
                ?>
                <form id="formVerLayout" method="get" class="row g-4 mb-4 px-2">
                    <div class="col-12">
                        <select name="deposito" id="deposito" class="form-select form-select-lg rounded-3" required>
                            <option value="">DEPÓSITO...</option>
                            <?php foreach ($depositos as $dep): ?>
                                <option value="<?= htmlspecialchars($dep->deposito) ?>" <?= $depositoSeleccionado === $dep->deposito ? 'selected' : '' ?>><?= htmlspecialchars($dep->deposito) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-12">
                        <select name="rack" id="rack" class="form-select form-select-lg rounded-3" required <?= !$depositoSeleccionado ? 'disabled' : '' ?>>
                            <option value="">RACK...</option>
                            <?php foreach ($racks as $rack): ?>
                                <option value="<?= htmlspecialchars($rack) ?>" <?= $rackSeleccionado === $rack ? 'selected' : '' ?>><?= htmlspecialchars($rack) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                </form>



                <?php
                function degradadoLateral($baseColor)
                {
                    return "background: linear-gradient(135deg, $baseColor 50%, #fff 100%) !important;";
                }
                ?>
                <?php if ($depositoSeleccionado && $rackSeleccionado): ?>
                    <?php foreach ($depositoLayout as $nombreDeposito => $racks): ?>
                        <div class="mb-4">
                            <?php foreach ($racks as $nombreRack => $columnas): ?>
                                <div class="mb-3 ps-3">
                                    <div class="row">
                                        <?php foreach ($columnas as $nombreColumna => $niveles): ?>
                                            <div class="col-6 col-md-2 columna text-center">
                                                <?php foreach ($niveles as $nombreNivel => $fondos): ?>
                                                    <div class="nivel">
                                                        <div class="titulo-seccion mb-4">
                                                            <?= $nombreDeposito . ' - ' . $nombreRack . ' <br> ' . $nombreColumna . ' - ' . $nombreNivel ?>
                                                        </div>

                                                        <?php foreach ($fondos as $index => $color): ?>
                                                            <?php
                                                            $posicionId = $db->get_var("
                                                                SELECT id FROM ope_layout
                                                                WHERE deposito = '$nombreDeposito'
                                                                AND rack = '$nombreRack'
                                                                AND columna = '$nombreColumna'
                                                                AND nivel = '$nombreNivel'
                                                                AND fondo = '" . ($index + 1) . "'
                                                            ");
                                                            $cuboColor = in_array($posicionId, $posicionesContadas) ? '#' . $posicionesColor[$posicionId] : '#fff';
                                                            ?>
                                                            <div
                                                                class="fondo-cubo"
                                                                data-deposito="<?= $nombreDeposito ?>"
                                                                data-rack="<?= $nombreRack ?>"
                                                                data-columna="<?= $nombreColumna ?>"
                                                                data-nivel="<?= $nombreNivel ?>"
                                                                data-fondo="<?= $index + 1 ?>">
                                                                <div class="cubo-inner">
                                                                    <?php for ($face = 0; $face < 6; $face++): ?>
                                                                        <?php
                                                                        $faceClass = ['front', 'back', 'right', 'left', 'top', 'bottom'][$face];
                                                                        if ($faceClass === 'front') {
                                                                            $faceStyle = "background-color: $cuboColor !important;";
                                                                        } else {
                                                                            $faceStyle = degradadoLateral($cuboColor);
                                                                        }
                                                                        ?>
                                                                        <div class="cara <?= $faceClass ?>" style="<?= $faceStyle ?>"></div>
                                                                    <?php endfor; ?>
                                                                </div>
                                                            </div>
                                                        <?php endforeach; ?>
                                                    </div>
                                                <?php endforeach; ?>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="container text-center text-muted">
                        <p>Seleccioná un depósito y un rack para ver el layout.</p>
                    </div>
                <?php endif; ?>



            </div>
        </div>

        <div class="modal fade" id="modalFormulario" tabindex="-1" aria-labelledby="modalFormularioLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <form id="formCubo">
                        <div class="modal-header">
                            <h5 class="modal-title" id="modalFormularioLabel">Información del pallet</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                        </div>
                        <div class="modal-body">

                            <input type="hidden" id="posicion_id" name="posicion_id">
                            <input type="hidden" id="ubicacionDeposito" name="deposito">
                            <input type="hidden" id="ubicacionRack" name="rack">
                            <input type="hidden" id="ubicacionColumna" name="columna">
                            <input type="hidden" id="ubicacionNivel" name="nivel">
                            <input type="hidden" id="ubicacionFondo" name="fondo">


                            <div class="mb-3">
                                <label for="palletId" class="form-label">ID (Nº de pallet)</label>
                                <input type="number" class="form-control form-control-lg" id="palletId" name="id">
                            </div>

                            <div class="mb-3">
                                <label for="cod" class="form-label">Código</label>
                                <input type="number" class="form-control form-control-lg" id="cod" name="cod">
                                <h4 id="denominacion" class="text-black"></h4>
                            </div>

                            <div class="mb-3">
                                <label for="lote" class="form-label">Lote</label>
                                <input type="text" class="form-control form-control-lg" id="lote" name="lote">
                            </div>

                            <div class="mb-3">
                                <label for="vencimiento" class="form-label">Vencimiento</label>
                                <div class="row">
                                    <div class="col">
                                        <input
                                            type="number"
                                            class="form-control form-control-lg"
                                            id="vencimiento-dia"
                                            name="vencimiento-dia"
                                            placeholder="DD"
                                            min="1"
                                            max="31"
                                            maxlength="2"
                                            oninput="if(this.value.length > 2) this.value = this.value.slice(0,2);">
                                    </div>
                                    <div class="col">
                                        <input
                                            type="number"
                                            class="form-control form-control-lg"
                                            id="vencimiento-mes"
                                            name="vencimiento-mes"
                                            placeholder="MM"
                                            min="1"
                                            max="12"
                                            maxlength="2"
                                            oninput="if(this.value.length > 2) this.value = this.value.slice(0,2);">
                                    </div>
                                    <div class="col">
                                        <input
                                            type="number"
                                            class="form-control form-control-lg"
                                            id="vencimiento-anio"
                                            name="vencimiento-anio"
                                            placeholder="YYYY"
                                            min="2025"
                                            max="2100"
                                            oninput="if(this.value.length > 4) this.value = this.value.slice(0,4);">
                                    </div>
                                </div>
                            </div>
                            <div class="mb-3">
                                <label for="vencimiento" class="form-label">Cantidad</label>
                                <input type="number" class="form-control form-control-lg" id="cantidad" name="cantidad">
                            </div>

                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-success">Guardar</button>
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <script src="conteoInteractivo.js"></script>

</body>

</html>