/* conteoInteractivo.js — MODO ENTERO por defecto + focus palletIdInput */
let cuboSeleccionado = null;
let pickingCache = []; // cache de paquetes en modo picking

$(function () {
  bindUI();
});

/* ============================
   HELPERS
   ============================ */
function focusPalletId() {
  // foco al primer ID visible (espera un tick para asegurar render)
  setTimeout(() => {
    const $inp = $("#palletsContainer .palletIdInput:visible").first();
    if ($inp.length) {
      $inp.focus().select();
      // opcional: scroll al input si quedara fuera de vista
      try {
        $inp[0].scrollIntoView({ behavior: "smooth", block: "center" });
      } catch (_) {}
    }
  }, 0);
}
function reloadPalletFromServer(forceModo) {
  const deposito = $("#ubicacionDeposito").val();
  const rack = $("#ubicacionRack").val();
  const columna = $("#ubicacionColumna").val();
  const nivel = $("#ubicacionNivel").val();
  const fondo = $("#ubicacionFondo").val();

  // Limpieza + spinner
  const $c = $("#palletsContainer").empty().addClass("row g-3");
  $c.html(`
    <div class="col-12 text-center py-4">
      <div class="spinner-border" role="status"></div>
      <div class="small mt-2">Cargando...</div>
    </div>
  `);

  $.ajax({
    url: "obtener_pallet.php",
    type: "POST",
    dataType: "json",
    // Si tu backend soporta recibir "modo", lo mandamos. Si no, no pasa nada.
    data: {
      deposito,
      rack,
      columna,
      nivel,
      fondo,
      modo: forceModo || undefined,
    },
    success: function (resp) {
      // Normalizamos
      const datos = Array.isArray(resp?.datos) ? resp.datos : [];
      const modoServidor = (resp?.modo || "").toLowerCase();

      // Tomamos el modo "forzado" del switch si vino, si no, el del servidor
      const modo = (
        forceModo ||
        modoServidor ||
        $("#modoConteo").val() ||
        "normal"
      ).toLowerCase();

      // Escribimos modo oculto + switch label
      $("#modoConteo").val(modo);
      const $label = $("#switchTipoPallet").next("label");
      const esPicking = modo === "picking";
      $("#switchTipoPallet").prop("checked", esPicking);
      $label.text(esPicking ? "Picking" : "Entero");

      // Render según modo
      if (esPicking) {
        pickingCache = datos.slice();
        if (pickingCache.length) {
          renderListadoPickingGrid(pickingCache);
        } else {
          // si no hay datos, muestro un placeholder o un editor vacío (tu elección)
          $c.html(`
            <div class="col-12">
              <div class="alert alert-warning">No hay pallets en Picking en esta posición.</div>
            </div>
          `);
        }
      } else {
        // modo normal (entero)
        const p = datos[0] || {};
        $("#bloqueIdActual").val(resp?.bloque_id || "");
        mostrarEditorDePaquete(p, 0);
        focusPalletId();
      }
    },
    error: function (xhr) {
      // Fallback sensato
      $("#modoConteo").val(forceModo || "normal");
      const esPicking = forceModo === "picking";
      $("#switchTipoPallet")
        .prop("checked", esPicking)
        .next("label")
        .text(esPicking ? "Picking" : "Entero");
      if (esPicking) {
        pickingCache = [];
        renderListadoPickingGrid(pickingCache);
      } else {
        mostrarEditorDePaquete({}, 0);
        focusPalletId();
      }
      console.error("obtener_pallet error:", xhr?.responseText || xhr.status);
    },
  });
}

/* ============================
   BIND DE EVENTOS PRINCIPALES
   ============================ */
function bindUI() {
  // Toggle Observación (delegación)
  $(document).on("click", ".toggleObservacion", function () {
    const target = $($(this).data("target"));
    target.slideToggle(200, () => {
      $(this).html(
        target.is(":visible")
          ? '<i class="bi bi-chevron-up"></i> Ocultar observaciones'
          : '<i class="bi bi-chat-dots"></i> Agregar observaciones'
      );
    });
  });

  // Agregar pallet manual (abre editor vacío)
  $("#btnAgregarPallet").on("click", function () {
    const idx = $(".pallet-item").length || 0;
    mostrarEditorDePaquete({}, idx);
    focusPalletId();
  });

  // Switch Normal / Picking
  $(document)
    .off("change", "#switchTipoPallet")
    .on("change", "#switchTipoPallet", function () {
      const esPicking = $(this).is(":checked");
      const forceModo = esPicking ? "picking" : "normal";
      // seteo UI mínima antes de cargar
      $("#modoConteo").val(forceModo);
      $(this)
        .next("label")
        .text(esPicking ? "Picking" : "Entero");

      // Vuelve a pedir al backend y renderiza acorde
      reloadPalletFromServer(forceModo);
    });

  // Click en un cubo
  $(".fondo-cubo").on("click", onCuboClick);

  // Cambio de depósito
  $("#deposito").on("change", onDepositoChange);

  // Cambio de rack
  $("#rack").on("change", function () {
    $("#formVerLayout").submit();
  });

  // Autocompletar pallet en Normal
  $(document).off("change", ".palletIdInput");
  $(document).on("change", ".palletIdInput", onPalletIdChange);

  // Padding día/mes
  $(document).on(
    "blur",
    "input[name$='[dia]'], input[name$='[mes]']",
    function () {
      const val = String($(this).val() || "");
      $(this).val(val ? val.padStart(2, "0") : "");
    }
  );

  // Submit
  $("#formCubo").on("submit", onFormSubmit);

  // Delegación: click en botón de paquete (picking)
  $(document).on("click", ".btn-pallet", function () {
    const idx = Number($(this).data("index"));
    const p = pickingCache[idx];
    if (p) {
      mostrarEditorDePaquete(p, idx);
      // si cambian a Entero luego desde acá, focus lo maneja el switch
    }
  });

  // Delegación: volver del editor al listado
  $(document).on("click", "#btnVolverListado", function () {
    renderListadoPickingGrid(pickingCache);
  });

  // Delegación: borrar pallet (funciona aunque se re-renderice)
  // Coloca esto dentro de bindUI()
  $(document)
    .off("click", ".btnBorrar")
    .on("click", ".btnBorrar", function () {
      const $btn = $(this);

      // 1) Resolver borrarId (prioriza data-*, luego id="btnBorrar_XXX", luego hidden)
      let borrarId = $btn.attr("data-borrar-id");
      if (borrarId == null || borrarId === "") {
        const rawId = $btn.attr("id") || "";
        const m = rawId.match(/^btnBorrar_(.+)$/);
        borrarId = m ? m[1] : "";
      }
      if (borrarId == null || borrarId === "") {
        borrarId =
          $btn
            .closest(".col-3, .pallet-item")
            .find("input[name*='[borrar_id]']")
            .val() ||
          $btn.closest(".pallet-item").find(".palletIdInput").val() ||
          "";
      }

      // 2) Normalizar a entero y validar
      borrarId = parseInt(borrarId, 10);
      if (!Number.isFinite(borrarId) || borrarId <= 0) {
        alert("No se encontró un ID válido para borrar.");
        return;
      }

      // 3) Confirmación
      if (!window.confirm(`¿Eliminar el registro #${borrarId}?`)) return;

      // 4) Spinner/disable
      const oldHtml = $btn.html();
      $btn
        .prop("disabled", true)
        .html(
          `<span class="spinner-border spinner-border-sm me-2"></span>Borrando...`
        );

      // 5) Llamar al backend
      borrarPallet(borrarId)
        .done(function (resp) {
          if (resp && resp.success) {
            // Cerrar modal
            const modalElement = document.getElementById("modalFormulario");
            bootstrap.Modal.getInstance(modalElement)?.hide();

            // Reconsultar estado de la posición para repintar el cubo
            const deposito = $("#ubicacionDeposito").val();
            const rack = $("#ubicacionRack").val();
            const columna = $("#ubicacionColumna").val();
            const nivel = $("#ubicacionNivel").val();
            const fondo = $("#ubicacionFondo").val();

            $.ajax({
              url: "obtener_pallet.php",
              type: "POST",
              dataType: "json",
              data: { deposito, rack, columna, nivel, fondo },
              success: function (resp2) {
                const modo = (resp2.modo || "normal").toLowerCase();
                const datos = Array.isArray(resp2.datos) ? resp2.datos : [];
                const resultados = datos.map((d) => ({
                  id: d.id || d.paquete_id || d.bloque_id || "",
                  codigo: d.cod || "",
                  color_web: d.color_web || "#ffffff",
                }));

                pintarCuboDePosicion({
                  modo,
                  resultados,
                  posicion_id: cuboSeleccionado?.data("posicion-id") || null,
                });

                // Limpieza UI
                $("#formCubo")[0].reset();
                $("#palletsContainer").empty().addClass("row g-3");
              },
            });
          } else {
            const msg =
              (resp && (resp.error || resp.msg)) || "No se pudo borrar.";
            alert("⚠️ " + msg);
          }
        })
        .fail(function (xhr) {
          const mensaje =
            xhr.responseJSON?.error ||
            xhr.responseText ||
            "Error inesperado al borrar.";
          alert("❌ " + mensaje);
        })
        .always(function () {
          $btn.prop("disabled", false).html(oldHtml);
        });
    });

  // Fuera de bindUI(): encapsula la llamada a tu fnBorrar.php (ezSQL 100%)
  function borrarPallet(id) {
    return $.ajax({
      url: "fnBorrar.php",
      type: "POST",
      dataType: "json",
      data: { id }, // envía { id: <conteo_id> }
    });
  }

  $("#palletsContainer").addClass("row g-3");
}

/* ============================
   HANDLERS
   ============================ */
function onCuboClick() {
  cuboSeleccionado = $(this);
  $("#formCubo")[0].reset();
  $("#palletsContainer").empty().addClass("row g-3");
  $("#bloqueIdActual").val("");
  pickingCache = [];

  const deposito = $(this).data("deposito");
  const rack = $(this).data("rack");
  const columna = $(this).data("columna");
  const nivel = $(this).data("nivel");
  const fondo = $(this).data("fondo");

  $("#ubicacionDeposito").val(deposito);
  $("#ubicacionRack").val(rack);
  $("#ubicacionColumna").val(columna);
  $("#ubicacionNivel").val(nivel);
  $("#ubicacionFondo").val(fondo);

  $("#modalFormularioLabel").html(
    `📦 Pallet(s): ${deposito} / ${rack} / ${columna} / Nivel ${nivel} / Fondo ${fondo}`
  );

  // >>> MODO POR DEFECTO: ENTERO (normal)
  $("#modoConteo").val("normal");
  $("#switchTipoPallet").prop("checked", false);
  $("#switchTipoPallet").next("label").text("Entero");

  const modalEl = document.getElementById("modalFormulario");
  const modal = new bootstrap.Modal(modalEl);
  modal.show();
  reloadPalletFromServer("normal");
  // Cuando el modal termina de mostrarse, si ya hay input, enfocar
  $(modalEl).one("shown.bs.modal", () => {
    // si por latencia aún no hay editor, onObtenerPalletSuccess hará el focus
    focusPalletId();
  });

  $.ajax({
    url: "obtener_pallet.php",
    type: "POST",
    dataType: "json",
    data: { deposito, rack, columna, nivel, fondo },
    success: onObtenerPalletSuccess,
    error: function () {
      // Fallback: normal con editor vacío + focus
      $("#modoConteo").val("normal");
      $("#switchTipoPallet").prop("checked", false).trigger("change");
      mostrarEditorDePaquete({}, 0);
      focusPalletId();
    },
  });
}

function onObtenerPalletSuccess(response) {
  $("#palletsContainer").empty().addClass("row g-3");

  if (response.existe && Array.isArray(response.datos)) {
    if (response.modo === "normal") {
      // ===== NORMAL =====
      $("#modoConteo").val("normal");
      $("#switchTipoPallet").prop("checked", false).trigger("change");

      const p = response.datos[0] || {};
      mostrarEditorDePaquete(p, 0);
      // foco al ID en normal
      focusPalletId();
    } else {
      // ===== PICKING =====
      $("#modoConteo").val("picking");
      $("#bloqueIdActual").val(response.bloque_id || "");
      pickingCache = response.datos.slice();
      renderListadoPickingGrid(pickingCache);
      $("#switchTipoPallet").prop("checked", true).trigger("change");
      // en picking no se enfoca ID (no aplica)
    }
  } else {
    // ===== POSICIÓN VACÍA → NORMAL (editor vacío) + foco
    $("#modoConteo").val("normal");
    $("#bloqueIdActual").val("");
    $("#switchTipoPallet").prop("checked", false).trigger("change");
    mostrarEditorDePaquete({}, 0);
    focusPalletId();
  }
}

function onDepositoChange() {
  const deposito = $(this).val();
  $("#rack")
    .prop("disabled", true)
    .html('<option value="">Cargando...</option>');
  if (deposito) {
    $.getJSON("getRacks.php", { deposito }, function (racks) {
      let options = '<option value="">Seleccionar...</option>';
      racks.forEach((r) => (options += `<option value="${r}">${r}</option>`));
      $("#rack").html(options).prop("disabled", false);
    });
  }
}

function onPalletIdChange() {
  const $input = $(this);
  const palletId = $input.val();
  const $bloque = $input.closest(".pallet-item");
  const modo = ($("#modoConteo").val() || "normal").toLowerCase();
  if (modo === "picking") return;

  if (palletId) {
    $.getJSON("buscar_pallet.php", { id: palletId }, function (data) {
      if (data && data.id) {
        $bloque.find("input[name*='[cod]']").val(data.cod || "");
        $bloque.find("input[name*='[lote]']").val(data.lote || "");
        $bloque.find("input[name*='[cantidad]']").val(data.cantidad || "");
        $bloque.find("input[name*='[dia]']").val(data.vencimiento_dia || "");
        $bloque.find("input[name*='[mes]']").val(data.vencimiento_mes || "");
        $bloque.find("input[name*='[anio]']").val(data.vencimiento_anio || "");
        $bloque
          .find("textarea[name*='[observacion]']")
          .val(data.observacion || "");
      }
    });
  }
}

function onFormSubmit(e) {
  e.preventDefault();

  const datos = $(this).serialize();

  $.ajax({
    url: "fnContar.php",
    method: "POST",
    data: datos,
    dataType: "json",
    success: function (respuesta) {
      if (respuesta.bloque_id) {
        $("#bloqueIdActual").val(respuesta.bloque_id);
      }

      if (respuesta.success) {
        try {
          pintarCuboDePosicion({
            modo: respuesta.modo || $("#modoConteo").val() || "normal",
            resultados: respuesta.resultados || [],
            posicion_id: respuesta.posicion_id,
          });
        } catch (err) {
          console.warn(
            "No se pudo pintar con la respuesta. Reconsultando…",
            err
          );
          const deposito = $("#ubicacionDeposito").val();
          const rack = $("#ubicacionRack").val();
          const columna = $("#ubicacionColumna").val();
          const nivel = $("#ubicacionNivel").val();
          const fondo = $("#ubicacionFondo").val();
          $.ajax({
            url: "obtener_pallet.php",
            type: "POST",
            dataType: "json",
            data: { deposito, rack, columna, nivel, fondo },
            success: function (resp) {
              const modo = (resp.modo || "normal").toLowerCase();
              const datos = Array.isArray(resp.datos) ? resp.datos : [];
              const resultados = datos.map((d) => ({
                id: d.id || d.paquete_id || d.bloque_id || "",
                codigo: d.cod || "",
                color_web: d.color_web || "#ffffff",
              }));
              pintarCuboDePosicion({
                modo,
                resultados,
                posicion_id: respuesta.posicion_id,
              });
            },
          });
        }

        // Cerrar modal y reset suave
        document.activeElement?.blur();
        const modalElement = document.getElementById("modalFormulario");
        bootstrap.Modal.getInstance(modalElement)?.hide();
        $("#formCubo")[0].reset();
      } else {
        alert("⚠️ " + (respuesta.error || "Operación no completada"));
      }
    },
    error: function (xhr) {
      const mensaje =
        xhr.responseJSON?.error ||
        xhr.responseText ||
        "Error inesperado. Intente de nuevo.";
      alert("❌ " + mensaje);
    },
  });
}

/* ============================
   PINTAR CUBO (helper)
   ============================ */
function pintarCuboDePosicion({ modo, resultados = [], posicion_id }) {
  if (!cuboSeleccionado || !posicion_id) return;

  const numPallets = Array.isArray(resultados) ? resultados.length : 0;
  const esPicking =
    (modo || $("#modoConteo").val() || "normal").toLowerCase() === "picking";

  // Pintar caras
  cuboSeleccionado.find(".cara").each(function () {
    const $face = $(this);
    const esFront = $face.hasClass("front");

    if (esPicking) {
      const grad = "linear-gradient(135deg, yellow 50%, black 50%)";
      $face.css("background", grad);
      if (esFront) $face.css("background-color", "");
      return;
    }

    // Modo Entero
    if (numPallets === 1) {
      const color = resultados[0]?.color_web || "#ffffff";
      if (esFront) {
        $face.css({ background: "", "background-color": color });
      } else {
        $face.css(
          "background",
          `linear-gradient(135deg, ${color} 50%, #fff 100%)`
        );
      }
    } else {
      // Más de un pallet → patrón
      const grad = "linear-gradient(135deg, yellow 50%, black 50%)";
      $face.css("background", grad);
      if (esFront) $face.css("background-color", "");
    }
  });

  // Badge / ticket
  const caraTicket = $("#caraTicket" + posicion_id);
  if (esPicking) {
    caraTicket.html(numPallets === 1 ? "1 picking" : `${numPallets} pickings`);
  } else {
    if (numPallets === 1) {
      const id = resultados[0]?.id ?? "";
      const codigo = resultados[0]?.codigo ?? "";
      caraTicket.html(`P-${id}<br><br>${codigo}`);
    } else {
      caraTicket.html(`${numPallets} pallets`);
    }
  }
}

/* ============================
   LISTADO PICKING (3 columnas)
   ============================ */
function buildPalletTitle(p) {
  const b = p?.bloque_id ?? $("#bloqueIdActual").val() ?? "—";
  const q = p?.paquete_id ?? "—";
  return `📦 PK-${b}-${q}`;
}

function renderListadoPickingGrid(lista) {
  const $c = $("#palletsContainer").empty().addClass("row g-3");
  if (!Array.isArray(lista) || !lista.length) {
    // no hay paquetes → editor vacío
    mostrarEditorDePaquete({}, 0);
    // si el usuario cambia a Entero luego, focus lo hará el switch
    return;
  }
  lista.forEach((p, i) => {
    const titulo = buildPalletTitle(p);
    const cod = p?.cod ?? "";
    const cant = p?.cantidad ?? "";
    $c.append(`
      <div class="col-12 col-md-6 col-lg-4">
        <button type="button" class="btn btn-pallet w-100 text-start shadow-sm" data-index="${i}">
          <div class="d-flex align-items-center gap-2 mb-1">
            <i class="bi bi-box-seam fs-5"></i>
            <span class="fw-semibold text-primary">${titulo}</span>
          </div>
          <div class="small text-muted">Cod: ${cod} | Cant: ${cant}</div>
        </button>
      </div>
    `);
  });
}

/* ============================
   EDITOR (picking o normal)
   ============================ */
function mostrarEditorDePaquete(p = {}, idx = 0) {
  const modoActual = ($("#modoConteo").val() || "normal").toLowerCase();

  const bloqueId = p?.bloque_id ?? $("#bloqueIdActual").val() ?? "";
  const paqueteId = p?.paquete_id ?? "";
  const idConteo = p?.id_conteo ?? ""; // nuevo en picking
  const idManual = p?.id ?? "";

  // ⬇️ Toma el mejor ID disponible según el modo
  const borrarId = idConteo;

  const palletIdLabel =
    modoActual === "picking" ? paqueteId || "—" : idManual || bloqueId || "—";
  const titulo =
    modoActual === "picking"
      ? `📦 PK-${bloqueId || "—"}-${palletIdLabel}`
      : `📦 Pallet ${idManual || "—"}`;

  const cod = p?.cod ?? "";
  const lote = p?.lote ?? "";
  const vdia = p?.vencimientodia ?? p?.vencimiento_dia ?? "";
  const vmes = p?.vencimientomes ?? p?.vencimiento_mes ?? "";
  const vanio = p?.vencimientoanio ?? p?.vencimiento_anio ?? "";
  const cant = p?.cantidad ?? "";
  const obs = p?.observacion ?? "";

  const mostrarIdGroup = modoActual === "normal";

  const $c = $("#palletsContainer").empty().addClass("row g-3");
  $c.append(`
    <div class="col-3">
      <button type="button"
              class="btn btn-outline-danger btn-sm mb-3 btnBorrar"
              id="btnBorrar_${borrarId}"
              data-borrar-id="${borrarId}"
              style="display:${
                modoActual === "normal" ? "inline-block" : "none"
              };">
        <i class="bi bi-trash"></i> Borrar
      </button>
      <!-- útil si querés que viaje al backend -->
      <input type="hidden" name="pallets[${idx}][borrar_id]" value="${borrarId}">
    </div>
    <div class="col-3">
      <button type="button" class="btn btn-outline-secondary btn-sm mb-3" id="btnVolverListado" style="display:${
        modoActual === "picking" ? "inline-block" : "none"
      };">
        <i class="bi bi-arrow-left"></i> Volver al listado
      </button>
    </div>
    <div class="col-12">
      <div class="pallet-item card shadow-sm border-2 border-primary-subtle">
        <div class="card-body p-3 bg-light-subtle rounded-3">
          <h6 class="fw-bold text-primary mb-3">${titulo}</h6>

          <input type="hidden" name="pallets[${idx}][bloque_id]"  value="${bloqueId}">
          <input type="hidden" name="pallets[${idx}][paquete_id]" value="${paqueteId}">

          <div class="mb-3 idPalletGroup" style="display:${
            mostrarIdGroup ? "block" : "none"
          };">
            <label class="form-label">ID (Nº Pallet)</label>
            <input type="number" inputmode="numeric" pattern="[0-9]*"
                   class="form-control form-control-lg palletIdInput"
                   name="pallets[${idx}][id]" value="${
    modoActual === "picking" ? bloqueId || "" : idManual
  }">
          </div>

          <div class="mb-3">
            <label class="form-label">Código</label>
            <input type="number" class="form-control form-control-lg" name="pallets[${idx}][cod]" value="${cod}">
          </div>

          <div class="mb-3">
            <label class="form-label">Lote</label>
            <input type="text" class="form-control form-control-lg" name="pallets[${idx}][lote]" value="${lote}">
          </div>

          <div class="mb-3">
            <label class="form-label">Vencimiento</label>
            <div class="row g-2">
              <div class="col-4"><input type="number" class="form-control form-control-lg" name="pallets[${idx}][dia]"  value="${vdia}"  placeholder="DD"  min="1" max="31"></div>
              <div class="col-4"><input type="number" class="form-control form-control-lg" name="pallets[${idx}][mes]"  value="${vmes}" placeholder="MM"  min="1" max="12"></div>
              <div class="col-4"><input type="number" class="form-control form-control-lg" name="pallets[${idx}][anio]" value="${vanio}" placeholder="YYYY" min="2025" max="2100"></div>
            </div>
          </div>

          <div class="mb-3">
            <label class="form-label">Cantidad</label>
            <input type="number" class="form-control form-control-lg" name="pallets[${idx}][cantidad]" value="${cant}">
          </div>

          <button type="button" class="btn btn-warning btn-lg w-100 toggleObservacion mb-2" data-target="#obs_${idx}">
            <i class="bi bi-chat-dots"></i> Agregar observaciones
          </button>
          <div class="observacionContainer" id="obs_${idx}" style="display:${
    obs ? "block" : "none"
  };">
            <textarea class="form-control form-control-lg" name="pallets[${idx}][observacion]" rows="2">${obs}</textarea>
          </div>
        </div>
      </div>
    </div>
  `);

  if (modoActual === "normal") focusPalletId();

  const esPickingAhora = $("#switchTipoPallet").is(":checked");
  $("#palletsContainer .idPalletGroup").toggle(
    !esPickingAhora ? true : modoActual === "normal"
  );
}
