let cuboSeleccionado = null;
$(document).ready(function () {
  $(".fondo-cubo").on("click", function () {
    cuboSeleccionado = $(this);

    // Limpiar campos primero
    $("#formCubo")[0].reset();

    // Obtener datos del cubo
    const deposito = $(this).data("deposito");
    const rack = $(this).data("rack");
    const columna = $(this).data("columna");
    const nivel = $(this).data("nivel");
    const fondo = $(this).data("fondo");

    // Cargar en campos ocultos
    $("#ubicacionDeposito").val(deposito);
    $("#ubicacionRack").val(rack);
    $("#ubicacionColumna").val(columna);
    $("#ubicacionNivel").val(nivel);
    $("#ubicacionFondo").val(fondo);

    // Título informativo del modal
    $("#modalFormularioLabel").html(
      `📦 Pallet: ${deposito} / ${rack} / ${columna} / Nivel ${nivel} / Fondo ${fondo}`
    );

    // Mostrar el modal
    const modal = new bootstrap.Modal(
      document.getElementById("modalFormulario")
    );
    modal.show();

    // Hacer petición AJAX para obtener datos existentes
    $.ajax({
      url: "obtener_pallet.php", // Archivo PHP que consultará la base de datos
      type: "POST",
      dataType: "json",
      data: {
        deposito: deposito,
        rack: rack,
        columna: columna,
        nivel: nivel,
        fondo: fondo,
      },
      success: function (response) {
        if (response.existe) {
          // Si existe el pallet, llenamos los campos
          $("#palletId").val(response.datos.id);
          $("#cod").val(response.datos.cod);
          $("#lote").val(response.datos.lote);
          $("#vencimiento-dia").val(response.datos.vencimientodia);
          $("#vencimiento-mes").val(response.datos.vencimientomes);
          $("#vencimiento-anio").val(response.datos.vencimientoanio);
          $("#cantidad").val(response.datos.cantidad);
        } else {
          // Si no existe, dejamos los campos vacíos (ya están reseteados)
          console.log("No hay datos para esta ubicación");
        }
      },
      error: function (xhr, status, error) {
        console.error("Error al obtener datos del pallet:", error);
      },
    });
  });
});


$(document).ready(function () {
  $("#deposito").on("change", function () {
    const deposito = $(this).val();

    $("#rack")
      .prop("disabled", true)
      .html('<option value="">Cargando...</option>');

    if (deposito) {
      $.getJSON("getRacks.php", { deposito: deposito }, function (racks) {
        let options = '<option value="">Seleccionar...</option>';
        racks.forEach(function (rack) {
          options += `<option value="${rack}">${rack}</option>`;
        });
        $("#rack").html(options).prop("disabled", false);
      });
    } else {
      $("#rack").html('<option value="">Seleccionar...</option>');
      // $("#rack").prop("disabled", false);
    }
  });


  $("#rack").on("change", function () {
      $("#formVerLayout").submit();
  });

$(function() {
    $('#palletId').on('change blur', function() {
        const palletId = $(this).val();
        if (palletId) {
            $.getJSON('buscar_pallet.php', { id: palletId }, function(data) {
                if (data && data.id) {
                    $('#cod').val(data.cod || '');
                    $('#denominacion').html(data.denominacion || '');
                    $('#lote').val(data.lote || '');
                    $('#cantidad').val(data.cantidad || '');
                    $('#vencimiento-dia').val(data.vencimiento_dia || '');
                    $('#vencimiento-mes').val(data.vencimiento_mes || '');
                    $('#vencimiento-anio').val(data.vencimiento_anio || '');
                    // Hacer focus en el campo cantidad
                    $('#cantidad').focus();
                } else {
                    // Limpia los campos si no se encuentra
                    $('#cod, #lote, #cantidad, #vencimiento-dia, #vencimiento-mes, #vencimiento-anio').val('');
                }
            });
        } else {
            $('#cod, #lote, #cantidad, #vencimiento-dia, #vencimiento-mes, #vencimiento-anio').val('');
        }
    });
});




  $("#formCubo").on("submit", function (e) {
    e.preventDefault();

    const datos = $(this).serialize();

    $.ajax({
      url: "fnContar.php",
      method: "POST",
      data: datos,
      dataType: "json",
      success: function (respuesta) {
          if (respuesta.success) {
              alert("✅ " + respuesta.message);

              document.activeElement.blur();

              const modalElement = document.getElementById("modalFormulario");
              const modalInstance = bootstrap.Modal.getInstance(modalElement);
              if (modalInstance) {
                  modalInstance.hide();
              }

              // Cambiar color del cubo contado, no solo la clase
              if (cuboSeleccionado && respuesta.color_web) {
                  cuboSeleccionado.addClass("cubo-contado");
                  console.log("Color del cubo:", respuesta.color_web);
                  // Para cubo 3D
                  cuboSeleccionado.find('.cara').each(function(i, el){
                      if ($(el).hasClass('front')) {
                          $(el).css('background-color', respuesta.color_web);
                      } else {
                          $(el).css('background', 'linear-gradient(135deg, ' + respuesta.color_web + ' 50%, #fff 100%)');
                      }
                  });
                  // Para cuadrado simple (si lo cambiaste por .cuadro-posicion)
                  // cuboSeleccionado.css('background-color', respuesta.color_web);
              }

              $("#formCubo")[0].reset();
          } else {
              alert("⚠️ " + respuesta.error);
          }
      },
      error: function (xhr) {
        let mensaje = "Error inesperado. Intente de nuevo.";
        if (xhr.responseJSON?.error) {
          mensaje = xhr.responseJSON.error;
        } else if (xhr.responseText) {
          mensaje = xhr.responseText;
        }
        alert("❌ " + mensaje);
      },
    });
  });

  document
    .getElementById("vencimiento-dia")
    .addEventListener("blur", function () {
      let val = this.value.padStart(2, "0");
      // Si el campo está vacío, no lo llenes con ceros
      this.value = this.value.length ? val : "";
    });
});

$(function() {
    $("#toggleObservacion").on("click", function() {
        $("#observacionContainer").slideToggle(200, function() {
            if ($(this).is(':visible')) {
                $("#observacion").focus();
                $("#toggleObservacion").text("Ocultar observaciones");
            } else {
                $("#toggleObservacion").text("Agregar observaciones");
            }
        });
    });
});

